/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.operations.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.labs.operations.services.HTTPUtils;

@Operation(id="HTTPlabs.Call", category="Services", label="HTTP Call", description="")
public class HTTPCall {
    public static final String ID = "HTTPlabs.Call";
    @Context
    protected OperationContext ctx;
    @Param(name="method", required=true, widget="Option", values={"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE"})
    String method;
    @Param(name="url", required=true)
    protected String url;
    @Param(name="headers", required=false)
    protected Properties headers;
    @Param(name="headersAsJSON", required=false)
    protected String headersAsJSON;
    @Param(name="body", required=false)
    protected String body;
    @Param(name="blobToSend", required=false)
    protected Blob blobToSend = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public Blob run() throws IOException {
        HttpURLConnection http = null;
        String result = "";
        String restResult = "";
        String error = "";
        boolean isUnknownHost = false;
        InputStream in = null;
        OutputStream out = null;
        try {
            String inputLine;
            URL theURL = new URL(this.url);
            http = (HttpURLConnection)theURL.openConnection();
            HTTPUtils.addHeaders(http, this.headers, this.headersAsJSON);
            this.method = this.method.toUpperCase();
            http.setRequestMethod(this.method);
            if (this.body != null && !this.body.isEmpty()) {
                http.setDoInput(true);
                http.setDoOutput(true);
                OutputStreamWriter writer = new OutputStreamWriter(http.getOutputStream());
                writer.write(this.body);
                writer.flush();
            } else if (this.blobToSend != null) {
                http.setDoInput(true);
                http.setDoOutput(true);
                in = this.blobToSend.getStream();
                out = http.getOutputStream();
                IOUtils.copy((InputStream)in, (OutputStream)out);
                out.flush();
            }
            InputStream is = http.getInputStream();
            BufferedReader bf = new BufferedReader(new InputStreamReader(is));
            StringBuffer sb = new StringBuffer();
            while ((inputLine = bf.readLine()) != null) {
                sb.append(inputLine);
            }
            bf.close();
            restResult = sb.toString();
        }
        catch (Exception e) {
            error = e.getMessage();
            if (e instanceof UnknownHostException) {
                isUnknownHost = true;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
            int status = 0;
            String statusMessage = "";
            if (isUnknownHost) {
                status = 0;
                statusMessage = "UnknownHostException";
            } else {
                try {
                    status = http.getResponseCode();
                    statusMessage = http.getResponseMessage();
                }
                catch (Exception e) {
                    statusMessage = "Error getting the status message itself";
                }
            }
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode resultObj = mapper.createObjectNode();
            resultObj.put("status", status);
            resultObj.put("statusMessage", statusMessage);
            resultObj.put("error", error);
            try {
                ObjectMapper resultAsObj = new ObjectMapper();
                JsonNode rootNode = resultAsObj.readTree(restResult);
                resultObj.set("result", rootNode);
            }
            catch (Exception e) {
                resultObj.put("result", restResult);
            }
            ObjectWriter ow = mapper.writer();
            result = ow.writeValueAsString((Object)resultObj);
        }
        return new StringBlob(result, "text/plain", "UTF-8");
    }
}

