/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.operations.images;

import java.io.IOException;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.labs.operations.images.ImagesSheetBuilder;

@Operation(id="ImagesSheet.Build", category="Conversion", label="Images Sheet Builder", description="Build an image sheet from the input documents. Use the thumbnails for documents that do not have the Picture facet. Outputs the resulting image (always a jpeg). See ImageMagick montage command line for details about the parameters")
public class ImagesSheetBuilderOp {
    public static final String ID = "ImagesSheet.Build";
    @Param(name="tile", required=false, values={"0"})
    protected String tile;
    @Param(name="labelPattern", required=false, values={"%f"})
    protected String labelPattern;
    @Param(name="backgroundColor", required=false, values={"white"})
    protected String backgroundColor;
    @Param(name="fillColor", required=false, values={"black"})
    protected String fillColor;
    @Param(name="font", required=false, values={"Helvetica"})
    protected String font;
    @Param(name="fontSize", required=false)
    protected Long fontSize;
    @Param(name="define", required=false, values={"jpeg:size=150x150>"})
    protected String define;
    @Param(name="geometry", required=false, values={"150x150>+20+20"})
    protected String geometry;
    @Param(name="imageViewToUse", required=false, values={"Medium"})
    protected String imageViewToUse;
    @Param(name="useDocTitle", required=false, values={"false"})
    protected boolean useDocTitle = false;

    @OperationMethod
    public Blob run(DocumentModelList input) throws NuxeoException, IOException, CommandNotAvailable {
        return this.run(input, null);
    }

    @OperationMethod
    public Blob run(BlobList input) throws NuxeoException, IOException, CommandNotAvailable {
        return this.run(null, input);
    }

    protected Blob run(DocumentModelList docs, BlobList blobs) throws NuxeoException, IOException, CommandNotAvailable {
        ImagesSheetBuilder isb = null;
        if (docs != null) {
            isb = new ImagesSheetBuilder(docs);
        } else if (blobs != null) {
            isb = new ImagesSheetBuilder(blobs);
        } else {
            return null;
        }
        isb.setTile(this.tile).setLabel(this.labelPattern).setBackground(this.backgroundColor).setFill(this.fillColor).setFont(this.font).setFontSize(this.fontSize).setDefine(this.define).setGeometry(this.geometry).setView(this.imageViewToUse).setUseDocTitle(this.useDocTitle);
        Blob result = isb.build();
        return result;
    }
}

