/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.operations.images;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailService;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.picture.api.PictureView;
import org.nuxeo.ecm.platform.picture.api.adapters.MultiviewPicture;
import org.nuxeo.runtime.api.Framework;

public class ImagesSheetBuilder {
    private static final Log log = LogFactory.getLog(ImagesSheetBuilder.class);
    public static final String DEFAULT_COMMAND = "IM-montage";
    public static final String DEFAULT_LABEL = "%f";
    public static final String NO_LABEL = "NO_LABEL";
    public static final String DEFAULT_TILE = "0";
    public static final String DEFAULT_FONT = "Helvetica";
    public static final int DEFAULT_FONT_SIZE = 12;
    public static final String DEFAULT_BACKGROUND = "white";
    public static final String DEFAULT_FILL = "black";
    public static final String DEFAULT_DEFINE = "jpeg:size=150x150>";
    public static final String DEFAULT_GEOMETRY = "150x150>+20+20";
    public static final String RESULT_FILE_NAME = "thumbnails-sheet.jpg";
    public static final String RESULT_MIMETYPE = "image/jpeg";
    public static final String DEFAULT_VIEW = "Medium";
    public static final boolean DEFAULT_USE_DOC_TITLE = false;
    protected String label = "%f";
    protected String font = "Helvetica";
    protected int fontSize = 12;
    protected String background = "white";
    protected String fill = "black";
    protected String define = "jpeg:size=150x150>";
    protected String geometry = "150x150>+20+20";
    protected String view = "Medium";
    protected boolean useDocTitle = false;
    protected String tile = "0";
    protected DocumentModelList docs = null;
    protected BlobList blobs = null;
    protected String command = "IM-montage";
    protected static ThumbnailService thumbnailService = null;

    public ImagesSheetBuilder(DocumentModelList inDocs) {
        this.docs = inDocs;
    }

    public ImagesSheetBuilder(BlobList inBlobs) {
        this.blobs = inBlobs;
    }

    protected ThumbnailService getThumbnailService() {
        if (thumbnailService == null) {
            thumbnailService = (ThumbnailService)Framework.getService(ThumbnailService.class);
        }
        return thumbnailService;
    }

    public Blob build() throws IOException, CommandNotAvailable, NuxeoException {
        return this.build(null);
    }

    public Blob build(CmdParameters moreParameters) throws IOException, CommandNotAvailable, NuxeoException {
        Blob result = null;
        if (this.docs == null && this.blobs == null) {
            return null;
        }
        if (this.docs != null && this.docs.size() < 1) {
            return null;
        }
        if (this.blobs != null && this.blobs.size() < 1) {
            return null;
        }
        if (this.docs != null) {
            this.blobs = new BlobList();
            boolean useView = StringUtils.isNotBlank((CharSequence)this.view);
            for (Iterator doc : this.docs) {
                Blob blob = null;
                if (doc.hasFacet("Picture")) {
                    PictureView pv;
                    MultiviewPicture mvp;
                    if (useView && (mvp = (MultiviewPicture)doc.getAdapter(MultiviewPicture.class)) != null && (pv = mvp.getView(this.view)) != null) {
                        blob = pv.getBlob();
                    }
                    if (blob == null) {
                        blob = (Blob)doc.getPropertyValue("file:content");
                    }
                }
                if (blob == null) {
                    blob = this.getThumbnailService().getThumbnail((DocumentModel)doc, doc.getCoreSession());
                }
                if (this.useDocTitle) {
                    blob.setFilename(doc.getTitle());
                }
                this.blobs.add((Object)blob);
            }
        }
        File tempDir = Files.createTempDir();
        Object fileList = "";
        for (Blob b : this.blobs) {
            if (b == null) continue;
            File f = new File(tempDir, b.getFilename());
            fileList = (String)fileList + "\"" + f.getAbsolutePath() + "\"\n";
            b.transferTo(f);
        }
        File listOfFiles = new File(tempDir, "list.txt");
        FileUtils.writeStringToFile((File)listOfFiles, (String)fileList, (String)"UTF-8");
        result = Blobs.createBlobWithExtension((String)".jpg");
        String outputFilePath = result.getFile().getAbsolutePath();
        CmdParameters params = new CmdParameters();
        if (this.label != null && this.label.equals(NO_LABEL)) {
            this.label = "";
        }
        params.addNamedParameter("label", this.label);
        params.addNamedParameter("font", this.font);
        params.addNamedParameter("fontSize", "" + this.fontSize);
        params.addNamedParameter("background", this.background);
        params.addNamedParameter("fill", this.fill);
        params.addNamedParameter("define", this.define);
        params.addNamedParameter("geometry", this.geometry);
        params.addNamedParameter("tile", this.tile);
        params.addNamedParameter("listFilePath", listOfFiles);
        params.addNamedParameter("targetFilePath", outputFilePath);
        if (moreParameters != null) {
            Map more = moreParameters.getParameters();
            for (Map.Entry entry : more.entrySet()) {
                params.addNamedParameter((String)entry.getKey(), ((CmdParameters.ParameterValue)entry.getValue()).getValue());
            }
        }
        CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
        ExecResult clResult = cles.execCommand(this.command, params);
        if (!result.getFile().exists() || result.getFile().length() == 0L) {
            result = null;
            log.error((Object)("Failed to build the Images Sheet: \nCommand Line: " + clResult.getCommandLine() + "\nResult code: " + clResult.getReturnCode() + "\nError: " + clResult.getError()));
            throw new NuxeoException("Failed to build the Images Sheet");
        }
        result.setMimeType(RESULT_MIMETYPE);
        result.setFilename(RESULT_FILE_NAME);
        FileUtils.deleteDirectory((File)tempDir);
        return result;
    }

    public String getCommand() {
        return this.command;
    }

    public ImagesSheetBuilder setCommand(String value) {
        this.command = StringUtils.isBlank((CharSequence)value) ? DEFAULT_COMMAND : value;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public ImagesSheetBuilder setLabel(String value) {
        this.label = StringUtils.isBlank((CharSequence)value) ? DEFAULT_LABEL : value;
        return this;
    }

    public String getFont() {
        return this.font;
    }

    public ImagesSheetBuilder setFont(String value) {
        this.font = StringUtils.isBlank((CharSequence)value) ? DEFAULT_FONT : value;
        return this;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public ImagesSheetBuilder setFontSize(int value) {
        this.fontSize = value <= 0 ? 12 : value;
        return this;
    }

    public ImagesSheetBuilder setFontSize(Long value) {
        this.fontSize = value == null || value.intValue() <= 0 ? 12 : value.intValue();
        return this;
    }

    public String getBackground() {
        return this.background;
    }

    public ImagesSheetBuilder setBackground(String value) {
        this.background = StringUtils.isBlank((CharSequence)value) ? DEFAULT_BACKGROUND : value;
        return this;
    }

    public String getFill() {
        return this.fill;
    }

    public ImagesSheetBuilder setFill(String value) {
        this.fill = StringUtils.isBlank((CharSequence)value) ? DEFAULT_FILL : value;
        return this;
    }

    public String getDefine() {
        return this.define;
    }

    public ImagesSheetBuilder setDefine(String value) {
        this.define = StringUtils.isBlank((CharSequence)value) ? DEFAULT_DEFINE : value;
        return this;
    }

    public String getGeometry() {
        return this.geometry;
    }

    public ImagesSheetBuilder setGeometry(String value) {
        this.geometry = StringUtils.isBlank((CharSequence)value) ? DEFAULT_GEOMETRY : value;
        return this;
    }

    public String getTile() {
        return this.tile;
    }

    public ImagesSheetBuilder setTile(String value) {
        this.tile = StringUtils.isBlank((CharSequence)value) ? DEFAULT_TILE : value;
        return this;
    }

    public String getView() {
        return this.view;
    }

    public ImagesSheetBuilder setView(String value) {
        this.view = StringUtils.isBlank((CharSequence)value) ? DEFAULT_VIEW : value;
        return this;
    }

    public boolean useDocTitle() {
        return this.useDocTitle;
    }

    public ImagesSheetBuilder setUseDocTitle(boolean value) {
        this.useDocTitle = value;
        return this;
    }
}

