/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.decimal.gps.core.operation;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.schema.types.TypeException;
import org.nuxeo.labs.decimal.gps.core.util.GPSExifToolProcessor;

@Operation(id="Document.GetGPSData", category="Document", label="Get GPS Data", description="Get GPS data using exiftool with the -n switch.")
public class GetGPSData {
    public static final String ID = "Document.GetGPSData";
    private static final Log log = LogFactory.getLog(GetGPSData.class);
    private static final String GPS_KEY_POSITION = "GPSPosition";
    private static final String GPS_KEY_LATITUDE = "GPSLatitude";
    private static final String GPS_KEY_LONGITUDE = "GPSLongitude";
    @Context
    protected CoreSession session;
    @Param(name="longitudeField", required=false)
    protected String longitudeField;
    @Param(name="latitudeField", required=false)
    protected String latitudeField;
    @Param(name="positionField", required=false)
    protected String positionField;
    @Param(name="xpath", required=false, values={"file:content"})
    protected String xpath = "file:content";

    @OperationMethod
    public DocumentModel run(DocumentModel input) throws TypeException, OperationException {
        if (!input.hasFacet("Picture")) {
            throw new TypeException("Picture document required");
        }
        if (this.longitudeField == null && this.latitudeField == null && this.positionField == null) {
            throw new OperationException("Need at least one parameter");
        }
        Property fileProp = input.getProperty(this.xpath);
        Blob blob = (Blob)fileProp.getValue();
        if (blob == null) {
            throw new OperationException("Need a picture blob at xpath " + this.xpath);
        }
        GPSExifToolProcessor myExifToolProcessor = new GPSExifToolProcessor();
        Map<String, Object> result = myExifToolProcessor.readGPSMetadata(blob);
        if (result.containsKey(GPS_KEY_POSITION) && this.positionField != null) {
            input.setPropertyValue(this.positionField, (Serializable)((Object)((String)result.get(GPS_KEY_POSITION))));
        }
        if (result.containsKey(GPS_KEY_LATITUDE) && this.latitudeField != null) {
            input.setPropertyValue(this.latitudeField, (Serializable)((Object)result.get(GPS_KEY_LATITUDE).toString()));
        }
        if (result.containsKey(GPS_KEY_LONGITUDE) && this.longitudeField != null) {
            input.setPropertyValue(this.longitudeField, (Serializable)((Object)result.get(GPS_KEY_LONGITUDE).toString()));
        }
        return input;
    }
}

