/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.security;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserAdapter;
import org.nuxeo.ecm.platform.usermanager.UserAdapterImpl;
import org.nuxeo.ecm.platform.usermanager.exceptions.InvalidPasswordException;
import org.nuxeo.ecm.platform.usermanager.exceptions.UserAlreadyExistsException;
import org.nuxeo.ecm.user.invite.UserInvitationService;
import org.nuxeo.ecm.webapp.security.AbstractUserGroupManagement;
import org.nuxeo.ecm.webapp.security.UpdateUserUnrestricted;
import org.nuxeo.runtime.api.Framework;

@Name(value="userManagementActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class UserManagementActions
extends AbstractUserGroupManagement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(UserManagementActions.class);
    public static final String USERS_TAB = "USER_CENTER:UsersGroupsHome:UsersHome";
    public static final String USERS_LISTING_CHANGED = "usersListingChanged";
    public static final String USERS_SEARCH_CHANGED = "usersSearchChanged";
    public static final String USER_SELECTED_CHANGED = "selectedUserChanged";
    public static final String SELECTED_LETTER_CHANGED = "selectedLetterChanged";
    protected String selectedLetter = "";
    protected DocumentModel selectedUser;
    protected DocumentModel newUser;
    protected boolean immediateCreation = false;
    protected boolean createAnotherUser = false;
    protected String defaultRepositoryName = null;
    protected String oldPassword;

    @Override
    protected String computeListingMode() {
        return this.userManager.getUserListingMode();
    }

    public DocumentModel getSelectedUser() {
        this.shouldResetStateOnTabChange = true;
        return this.selectedUser;
    }

    public void setSelectedUser(DocumentModel user) {
        this.fireSeamEvent(USER_SELECTED_CHANGED);
        this.selectedUser = user;
    }

    @Deprecated
    public void setSelectedUser(String userName) {
        this.setSelectedUser(this.refreshUser(userName));
    }

    public void setSelectedUserName(String userName) {
        this.setSelectedUser(this.refreshUser(userName));
    }

    public String getSelectedUserName() {
        return this.selectedUser.getId();
    }

    protected DocumentModel refreshUser(String userName) {
        return this.userManager.getUserModel(userName);
    }

    public String getSelectedLetter() {
        return this.selectedLetter;
    }

    public void setSelectedLetter(String selectedLetter) {
        if (selectedLetter != null && !selectedLetter.equals(this.selectedLetter)) {
            this.selectedLetter = selectedLetter;
            this.fireSeamEvent(SELECTED_LETTER_CHANGED);
        }
        this.selectedLetter = selectedLetter;
    }

    public DocumentModel getNewUser() {
        if (this.newUser == null) {
            this.newUser = this.userManager.getBareUserModel();
        }
        return this.newUser;
    }

    public boolean getAllowEditUser() {
        return this.selectedUser != null && this.getCanEditUsers(true) && !BaseSession.isReadOnlyEntry((DocumentModel)this.selectedUser);
    }

    protected boolean getCanEditUsers(boolean allowCurrentUser) {
        NuxeoPrincipal selectedPrincipal;
        if (this.userManager.areUsersReadOnly().booleanValue()) {
            return false;
        }
        if (this.selectedUser != null && this.userManager.getAnonymousUserId() != null && this.userManager.getAnonymousUserId().equals(this.selectedUser.getId())) {
            return false;
        }
        if (this.selectedUser != null && (selectedPrincipal = this.userManager.getPrincipal(this.selectedUser.getId())).isAdministrator() && !((NuxeoPrincipal)this.currentUser).isAdministrator()) {
            return false;
        }
        if (this.currentUser instanceof NuxeoPrincipal) {
            NuxeoPrincipal pal = (NuxeoPrincipal)this.currentUser;
            if (this.webActions.checkFilter("usersGroupsManagementAccess")) {
                return true;
            }
            if (allowCurrentUser && this.selectedUser != null && pal.getName().equals(this.selectedUser.getId())) {
                return true;
            }
        }
        return false;
    }

    public boolean getAllowChangePassword() {
        return this.selectedUser != null && this.getCanEditUsers(true) && !BaseSession.isReadOnlyEntry((DocumentModel)this.selectedUser);
    }

    public boolean getAllowCreateUser() {
        return this.getCanEditUsers(false);
    }

    public boolean getAllowDeleteUser() {
        return this.selectedUser != null && this.getCanEditUsers(false) && !BaseSession.isReadOnlyEntry((DocumentModel)this.selectedUser);
    }

    public void clearSearch() {
        this.searchString = null;
        this.fireSeamEvent(USERS_SEARCH_CHANGED);
    }

    public void createUser() {
        try {
            if (this.immediateCreation) {
                this.setSelectedUser(this.userManager.createUser(this.newUser));
                this.immediateCreation = false;
                this.facesMessages.add(StatusMessage.Severity.INFO, this.resourcesAccessor.getMessages().get("info.userManager.userCreated"), new Object[0]);
                if (this.createAnotherUser) {
                    this.showCreateForm = true;
                } else {
                    this.showCreateForm = false;
                    this.showUserOrGroup = true;
                    this.detailsMode = null;
                }
                this.fireSeamEvent(USERS_LISTING_CHANGED);
            } else {
                UserInvitationService userRegistrationService = (UserInvitationService)Framework.getService(UserInvitationService.class);
                HashMap<String, String> additionalInfos = new HashMap<String, String>();
                additionalInfos.put("registration:originatingUser", this.currentUser.getName());
                UserAdapterImpl newUserAdapter = new UserAdapterImpl(this.newUser, this.userManager);
                DocumentModel userRegistrationDoc = this.wrapToUserRegistration((UserAdapter)newUserAdapter);
                userRegistrationService.submitRegistrationRequest(userRegistrationDoc, additionalInfos, UserInvitationService.ValidationMethod.EMAIL, true);
                this.facesMessages.add(StatusMessage.Severity.INFO, this.resourcesAccessor.getMessages().get("info.userManager.userInvited"), new Object[0]);
                if (this.createAnotherUser) {
                    this.showCreateForm = true;
                } else {
                    this.showCreateForm = false;
                    this.showUserOrGroup = false;
                    this.detailsMode = null;
                }
            }
            this.newUser = null;
        }
        catch (UserAlreadyExistsException e) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.resourcesAccessor.getMessages().get("error.userManager.userAlreadyExists"), new Object[0]);
        }
        catch (InvalidPasswordException e) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.resourcesAccessor.getMessages().get("error.userManager.invalidPassword"), new Object[0]);
        }
        catch (Exception e) {
            String message = e.getLocalizedMessage();
            if (e.getCause() != null) {
                message = message + e.getCause().getLocalizedMessage();
            }
            log.error((Object)message, (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, message, new Object[0]);
        }
    }

    private String getDefaultRepositoryName() {
        if (this.defaultRepositoryName == null) {
            try {
                this.defaultRepositoryName = ((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepository().getName();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.defaultRepositoryName;
    }

    public void updateUser() {
        try {
            UpdateUserUnrestricted runner = new UpdateUserUnrestricted(this.getDefaultRepositoryName(), this.selectedUser);
            runner.runUnrestricted();
        }
        catch (InvalidPasswordException e) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.resourcesAccessor.getMessages().get("error.userManager.invalidPassword"), new Object[0]);
        }
        this.detailsMode = "view";
        this.fireSeamEvent(USERS_LISTING_CHANGED);
    }

    public String changePassword() {
        try {
            this.updateUser();
        }
        catch (InvalidPasswordException e) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.resourcesAccessor.getMessages().get("error.userManager.invalidPassword"), new Object[0]);
            return null;
        }
        this.detailsMode = "view";
        String message = this.resourcesAccessor.getMessages().get("label.userManager.password.changed");
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, message, new Object[0]);
        this.fireSeamEvent(USERS_LISTING_CHANGED);
        return null;
    }

    public String updateProfilePassword() {
        if (this.userManager.checkUsernamePassword(this.currentUser.getName(), this.oldPassword)) {
            try {
                this.doAsSystemUser(new Runnable(){

                    @Override
                    public void run() {
                        UserManagementActions.this.userManager.updateUser(UserManagementActions.this.selectedUser);
                    }
                });
            }
            catch (InvalidPasswordException e) {
                this.facesMessages.add(StatusMessage.Severity.ERROR, this.resourcesAccessor.getMessages().get("error.userManager.invalidPassword"), new Object[0]);
                return null;
            }
        } else {
            String message = this.resourcesAccessor.getMessages().get("label.userManager.old.password.error");
            this.facesMessages.add(FacesMessage.SEVERITY_ERROR, message, new Object[0]);
            return null;
        }
        String message = this.resourcesAccessor.getMessages().get("label.userManager.password.changed");
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, message, new Object[0]);
        this.detailsMode = "view";
        this.fireSeamEvent(USERS_LISTING_CHANGED);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAsSystemUser(Runnable runnable) {
        LoginContext loginContext;
        try {
            loginContext = Framework.login();
        }
        catch (LoginException e) {
            throw new NuxeoException((Throwable)e);
        }
        try {
            runnable.run();
        }
        finally {
            try {
                if (loginContext != null) {
                    loginContext.logout();
                }
            }
            catch (LoginException e) {
                throw new NuxeoException("Cannot log out system user", (Throwable)e);
            }
        }
    }

    public void deleteUser() {
        this.userManager.deleteUser(this.selectedUser);
        this.selectedUser = null;
        this.showUserOrGroup = false;
        this.fireSeamEvent(USERS_LISTING_CHANGED);
    }

    public void validateUserName(FacesContext context, UIComponent component, Object value) {
        if (!(value instanceof String) || !StringUtils.containsOnly((String)((String)value), (String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_-0123456789.@")) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.userManager.wrong.username"), null);
            context.addMessage(null, message);
            throw new ValidatorException(message);
        }
    }

    public void validateGroups(FacesContext context, UIComponent component, Object value) {
        List groups;
        UIInput groupsComponent = this.getReferencedComponent("groupsValueHolderId", component);
        List list = groups = groupsComponent == null ? null : (List)groupsComponent.getLocalValue();
        if (groups == null || groups.isEmpty()) {
            return;
        }
        if (!this.isAllowedToAdminGroups(groups)) {
            this.throwValidationException(context, "label.userManager.invalidGroupSelected", new Object[0]);
        }
    }

    boolean isAllowedToAdminGroups(List<String> groups) {
        NuxeoPrincipalImpl nuxeoPrincipal = (NuxeoPrincipalImpl)this.currentUser;
        if (!nuxeoPrincipal.isAdministrator()) {
            List<String> adminGroups = this.getAllAdminGroups();
            for (String group : groups) {
                if (!adminGroups.contains(group)) continue;
                return false;
            }
        }
        return true;
    }

    private void throwValidationException(FacesContext context, String message, Object ... messageArgs) {
        FacesMessage fmessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)message, (Object[])messageArgs), null);
        throw new ValidatorException(fmessage);
    }

    private UIInput getReferencedComponent(String attribute, UIComponent component) {
        Map attributes = component.getAttributes();
        String targetComponentId = (String)attributes.get(attribute);
        if (targetComponentId == null) {
            log.error((Object)String.format("Target component id (%s) not found in attributes", attribute));
            return null;
        }
        UIInput targetComponent = (UIInput)component.findComponent(targetComponentId);
        if (targetComponent == null) {
            return null;
        }
        return targetComponent;
    }

    public void validatePassword(FacesContext context, UIComponent component, Object value) {
        Object firstPassword = this.getReferencedComponent("firstPasswordInputId", component).getLocalValue();
        Object secondPassword = this.getReferencedComponent("secondPasswordInputId", component).getLocalValue();
        if (firstPassword == null || secondPassword == null) {
            log.error((Object)"Cannot validate passwords: value(s) not found");
            return;
        }
        if (!firstPassword.equals(secondPassword)) {
            this.throwValidationException(context, "label.userManager.password.not.match", new Object[0]);
        }
    }

    private DocumentModel wrapToUserRegistration(UserAdapter newUserAdapter) {
        UserInvitationService userRegistrationService = (UserInvitationService)Framework.getService(UserInvitationService.class);
        DocumentModel newUserRegistration = userRegistrationService.getUserRegistrationModel(null);
        newUserRegistration.setPropertyValue(userRegistrationService.getConfiguration().getUserInfoUsernameField(), (Serializable)((Object)newUserAdapter.getName()));
        newUserRegistration.setPropertyValue(userRegistrationService.getConfiguration().getUserInfoFirstnameField(), (Serializable)((Object)newUserAdapter.getFirstName()));
        newUserRegistration.setPropertyValue(userRegistrationService.getConfiguration().getUserInfoLastnameField(), (Serializable)((Object)newUserAdapter.getLastName()));
        newUserRegistration.setPropertyValue(userRegistrationService.getConfiguration().getUserInfoEmailField(), (Serializable)((Object)newUserAdapter.getEmail()));
        newUserRegistration.setPropertyValue(userRegistrationService.getConfiguration().getUserInfoGroupsField(), (Serializable)newUserAdapter.getGroups().toArray());
        newUserRegistration.setPropertyValue(userRegistrationService.getConfiguration().getUserInfoCompanyField(), (Serializable)((Object)newUserAdapter.getCompany()));
        String tenantId = newUserAdapter.getTenantId();
        if (StringUtils.isBlank((String)tenantId)) {
            tenantId = ((NuxeoPrincipal)this.currentUser).getTenantId();
        }
        newUserRegistration.setPropertyValue(userRegistrationService.getConfiguration().getUserInfoTenantIdField(), (Serializable)((Object)tenantId));
        return newUserRegistration;
    }

    @Factory(value="notReadOnly", scope=ScopeType.APPLICATION)
    public boolean isNotReadOnly() {
        return !Framework.isBooleanPropertyTrue((String)"org.nuxeo.ecm.webapp.readonly.mode");
    }

    public List<String> getUserVirtualGroups(String userId) {
        NuxeoPrincipal principal = this.userManager.getPrincipal(userId);
        if (principal instanceof NuxeoPrincipalImpl) {
            NuxeoPrincipalImpl user = (NuxeoPrincipalImpl)principal;
            return user.getVirtualGroups();
        }
        return null;
    }

    public String viewUser(String userName) {
        this.webActions.setCurrentTabIds("MAIN_TABS:home,USER_CENTER:UsersGroupsHome:UsersHome");
        this.setSelectedUser(userName);
        this.setShowUser(Boolean.TRUE.toString());
        return "view_home";
    }

    public String viewUser() {
        if (this.selectedUser != null) {
            return this.viewUser(this.selectedUser.getId());
        }
        return null;
    }

    public void setShowUser(String showUser) {
        this.showUserOrGroup = Boolean.valueOf(showUser);
        this.shouldResetStateOnTabChange = false;
    }

    protected void fireSeamEvent(String eventName) {
        Events evtManager = Events.instance();
        evtManager.raiseEvent(eventName, new Object[0]);
    }

    @Factory(value="anonymousUserDefined", scope=ScopeType.APPLICATION)
    public boolean anonymousUserDefined() {
        return this.userManager.getAnonymousUserId() != null;
    }

    @Observer(value={"usersListingChanged"})
    public void onUsersListingChanged() {
        this.contentViewActions.refreshOnSeamEvent(USERS_LISTING_CHANGED);
        this.contentViewActions.resetPageProviderOnSeamEvent(USERS_LISTING_CHANGED);
    }

    @Observer(value={"usersSearchChanged"})
    public void onUsersSearchChanged() {
        this.contentViewActions.refreshOnSeamEvent(USERS_SEARCH_CHANGED);
        this.contentViewActions.resetPageProviderOnSeamEvent(USERS_SEARCH_CHANGED);
    }

    @Observer(value={"selectedLetterChanged"})
    public void onSelectedLetterChanged() {
        this.contentViewActions.refreshOnSeamEvent(SELECTED_LETTER_CHANGED);
        this.contentViewActions.resetPageProviderOnSeamEvent(SELECTED_LETTER_CHANGED);
    }

    @Observer(value={"currentTabChanged_MAIN_TABS", "currentTabChanged_NUXEO_ADMIN", "currentTabChanged_USER_CENTER", "currentTabChanged_UsersGroupsManager_sub_tab", "currentTabChanged_UsersGroupsHome_sub_tab", "currentTabSelected_MAIN_TABS", "currentTabSelected_NUXEO_ADMIN", "currentTabSelected_USER_CENTER", "currentTabSelected_UsersGroupsManager_sub_tab", "currentTabSelected_UsersGroupsHome_sub_tab"})
    public void resetState() {
        if (this.shouldResetStateOnTabChange) {
            this.newUser = null;
            this.selectedUser = null;
            this.showUserOrGroup = false;
            this.showCreateForm = false;
            this.immediateCreation = false;
            this.detailsMode = "view";
        }
    }

    public boolean isImmediateCreation() {
        return this.immediateCreation;
    }

    public void setImmediateCreation(boolean immediateCreation) {
        this.immediateCreation = immediateCreation;
    }

    public boolean isCreateAnotherUser() {
        return this.createAnotherUser;
    }

    public void setCreateAnotherUser(boolean createAnotherUser) {
        this.createAnotherUser = createAnotherUser;
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
    }
}

