/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.permissions;

import java.io.Serializable;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.admin.permissions.PermissionsPurgeWork;
import org.nuxeo.ecm.admin.permissions.PurgeWorkStatus;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="adminPermissionsActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class AdminPermissionsActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PERMISSIONS_PURGE_CONTENT_VIEW = "PERMISSIONS_PURGE";
    public static final String CATEGORY_PURGE_WORK = "permissionsPurge";
    public static final String ACE_STATUS_ALL = "all";
    @In(create=true)
    protected ContentViewActions contentViewActions;
    protected String purgeWorkId;
    protected String selectedACEStatus = "all";

    public String getSelectedACEStatus() {
        return this.selectedACEStatus;
    }

    public void setSelectedACEStatus(String selectedACEStatus) {
        this.selectedACEStatus = selectedACEStatus;
    }

    public String getACEStatusFixedPart() {
        switch (this.selectedACEStatus) {
            case "all": {
                return null;
            }
            case "0": {
                return "AND ecm:acl/*1/status = 0";
            }
            case "1": {
                return "AND (ecm:acl/*1/status IS NULL OR ecm:acl/*1/status = 1)";
            }
            case "2": {
                return "AND ecm:acl/*1/status = 2";
            }
        }
        return null;
    }

    public void doPurge() {
        ContentView contentView = this.contentViewActions.getContentView(PERMISSIONS_PURGE_CONTENT_VIEW);
        DocumentModel searchDocumentModel = contentView.getSearchDocumentModel();
        PermissionsPurgeWork work = new PermissionsPurgeWork(searchDocumentModel);
        this.purgeWorkId = work.launch();
    }

    public void cancelPurge() {
        ContentView contentView = this.contentViewActions.getContentView(PERMISSIONS_PURGE_CONTENT_VIEW);
        contentView.resetSearchDocumentModel();
        this.purgeWorkId = null;
    }

    public boolean canStartPurge() {
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        return workManager.getMetrics(CATEGORY_PURGE_WORK).getRunning().intValue() <= 0;
    }

    public PurgeWorkStatus getPurgeStatus() {
        if (this.purgeWorkId == null) {
            return null;
        }
        return PermissionsPurgeWork.getStatus((String)this.purgeWorkId);
    }
}

