/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.migration.MigrationDescriptor;
import org.nuxeo.runtime.migration.MigrationService;
import org.nuxeo.runtime.migration.MigrationServiceImpl;

@Name(value="migrationAdmin")
@Scope(value=ScopeType.CONVERSATION)
public class MigrationAdminBean
implements Serializable {
    private static final long serialVersionUID = 1L;

    public List<Map<String, Object>> getMigrationInfos() {
        MigrationService migrationService = (MigrationService)Framework.getService(MigrationService.class);
        ArrayList<Map<String, Object>> migrationInfos = new ArrayList<Map<String, Object>>();
        Map descriptors = ((MigrationServiceImpl)migrationService).getMigrationDescriptors();
        descriptors.values().forEach(descr -> {
            MigrationService.MigrationStatus status = migrationService.getStatus(descr.getId());
            HashMap<String, Object> migrationInfo = new HashMap<String, Object>();
            migrationInfo.put("id", descr.getId());
            migrationInfo.put("descriptor", descr);
            migrationInfo.put("status", status);
            if (!status.isRunning()) {
                String state = status.getState();
                ArrayList<MigrationDescriptor.MigrationStepDescriptor> steps = new ArrayList<MigrationDescriptor.MigrationStepDescriptor>();
                for (MigrationDescriptor.MigrationStepDescriptor step : descr.getSteps().values()) {
                    if (!step.getFromState().equals(state)) continue;
                    steps.add(step);
                }
                Collections.sort(steps, (a, b) -> a.getId().compareTo(b.getId()));
                migrationInfo.put("steps", steps);
            }
            migrationInfos.add(migrationInfo);
        });
        Collections.sort(migrationInfos, (a, b) -> ((String)a.get("id")).compareTo((String)b.get("id")));
        return migrationInfos;
    }

    public void runStep(String id, String step) {
        MigrationService migrationService = (MigrationService)Framework.getService(MigrationService.class);
        migrationService.runStep(id, step);
    }
}

