/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.htmleditor.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.platform.ui.web.htmleditor.api.HtmlEditorPluginService;
import org.nuxeo.ecm.platform.ui.web.htmleditor.service.HtmlEditorPluginDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class HtmlEditorPluginServiceImpl
extends DefaultComponent
implements HtmlEditorPluginService {
    public static final String PLUGINS_EXTENSION_POINT = "plugins";
    private Map<String, HtmlEditorPluginDescriptor> pluginsDescriptors;

    public void activate(ComponentContext context) {
        this.pluginsDescriptors = new HashMap<String, HtmlEditorPluginDescriptor>();
    }

    public void deactivate(ComponentContext context) {
        this.pluginsDescriptors = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (PLUGINS_EXTENSION_POINT.equals(extensionPoint)) {
            HtmlEditorPluginDescriptor descriptor = (HtmlEditorPluginDescriptor)contribution;
            if (descriptor.isRemove() && this.pluginsDescriptors.containsKey(descriptor.getPluginName())) {
                this.pluginsDescriptors.remove(descriptor.getPluginName());
            } else {
                this.pluginsDescriptors.put(descriptor.getPluginName(), descriptor);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (PLUGINS_EXTENSION_POINT.equals(extensionPoint)) {
            HtmlEditorPluginDescriptor descriptor = (HtmlEditorPluginDescriptor)contribution;
            this.pluginsDescriptors.remove(descriptor.getPluginName());
        }
    }

    @Override
    public List<String> getPluginsName() {
        return new ArrayList<String>(this.pluginsDescriptors.keySet());
    }

    @Override
    public String getFormattedPluginsNames() {
        return String.join((CharSequence)",", this.getPluginsName());
    }

    public List<String> getToolbarsButtonsNames() {
        return new ArrayList<String>(this.pluginsDescriptors.keySet());
    }

    @Override
    public String getFormattedToolbarsButtonsNames() {
        return String.join((CharSequence)",", this.getToolbarsButtonsNames());
    }

    @Override
    public Map<String, String> getToolbarsButtons() {
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, List> temp = new HashMap<String, List>();
        for (HtmlEditorPluginDescriptor htmlEditorPluginDescriptor : this.pluginsDescriptors.values()) {
            temp.computeIfAbsent(htmlEditorPluginDescriptor.getToolbarName(), key -> new ArrayList()).add(htmlEditorPluginDescriptor.getPluginButtonName());
        }
        for (Map.Entry entry : temp.entrySet()) {
            result.put((String)entry.getKey(), String.join((CharSequence)",", (Iterable)entry.getValue()));
        }
        return result;
    }
}

