/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.file;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.platform.ui.web.component.file.JSFBlobUploader;
import org.nuxeo.ecm.platform.ui.web.component.file.JSFBlobUploaderDescriptor;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class JSFBlobUploaderService
extends DefaultComponent {
    public static final String XP_UPLOADER = "uploader";
    protected JSFBlobUploaderDescriptorRegistry registry = new JSFBlobUploaderDescriptorRegistry();

    public void registerContribution(Object contrib, String xpoint, ComponentInstance contributor) {
        if (!XP_UPLOADER.equals(xpoint)) {
            throw new RuntimeException("Unknown extension point: " + xpoint);
        }
        this.registry.addContribution((JSFBlobUploaderDescriptor)contrib);
    }

    public void unregisterContribution(Object contrib, String xpoint, ComponentInstance contributor) {
        if (!XP_UPLOADER.equals(xpoint)) {
            throw new RuntimeException("Unknown extension point: " + xpoint);
        }
        this.registry.removeContribution((JSFBlobUploaderDescriptor)contrib);
    }

    public List<JSFBlobUploader> getJSFBlobUploaders() {
        return this.registry.getJSFBlobUploaders();
    }

    public JSFBlobUploader getJSFBlobUploader(String choice) {
        return this.registry.getJSFBlobUploader(choice);
    }

    protected static class JSFBlobUploaderDescriptorRegistry
    extends SimpleContributionRegistry<JSFBlobUploaderDescriptor> {
        protected JSFBlobUploaderDescriptorRegistry() {
        }

        public String getContributionId(JSFBlobUploaderDescriptor contrib) {
            return contrib.id;
        }

        public JSFBlobUploaderDescriptor clone(JSFBlobUploaderDescriptor orig) {
            return new JSFBlobUploaderDescriptor(orig);
        }

        public void merge(JSFBlobUploaderDescriptor src, JSFBlobUploaderDescriptor dst) {
            dst.merge(src);
        }

        public boolean isSupportingMerge() {
            return true;
        }

        public List<JSFBlobUploader> getJSFBlobUploaders() {
            ArrayList<JSFBlobUploader> uploaders = new ArrayList<JSFBlobUploader>(this.currentContribs.size());
            ArrayList descs = new ArrayList(this.currentContribs.values());
            Collections.sort(descs);
            for (JSFBlobUploaderDescriptor desc : descs) {
                JSFBlobUploader uploader = desc.getJSFBlobUploader();
                if (uploader == null || !uploader.isEnabled()) continue;
                uploaders.add(uploader);
            }
            return uploaders;
        }

        public JSFBlobUploader getJSFBlobUploader(String choice) {
            for (JSFBlobUploaderDescriptor desc : this.currentContribs.values()) {
                JSFBlobUploader uploader = desc.getJSFBlobUploader();
                if (uploader == null || !uploader.getChoice().equals(choice) || !uploader.isEnabled()) continue;
                return uploader;
            }
            return null;
        }
    }
}

