/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.directory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.platform.ui.web.directory.ChainSelect;
import org.nuxeo.ecm.platform.ui.web.directory.Selection;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.directory.ChainSelectActions;

@Name(value="chainSelectActions")
@Scope(value=ScopeType.SESSION)
public class ChainSelectActionsBean
implements ChainSelectActions,
Serializable {
    private static final long serialVersionUID = 27502317512904295L;
    private static final Log log = LogFactory.getLog(ChainSelectActionsBean.class);

    private ChainSelect getChainSelect(ActionEvent event) {
        UIComponent component = event.getComponent();
        while (!(component instanceof ChainSelect)) {
            component = component.getParent();
        }
        return (ChainSelect)component;
    }

    @Override
    public void add(ActionEvent event) {
        String[] submittedValue;
        ChainSelect chainSelect = this.getChainSelect(event);
        FacesContext context = FacesContext.getCurrentInstance();
        boolean allowBranchSelection = chainSelect.getBooleanProperty("allowBranchSelection", false);
        boolean allowRootSelection = chainSelect.getBooleanProperty("allowRootSelection", false);
        int size = chainSelect.getSize();
        String clientId = chainSelect.getClientId(context);
        LinkedHashMap<String, Selection> map = new LinkedHashMap<String, Selection>();
        for (Selection selection : chainSelect.getComponentValue()) {
            map.put(selection.getValue(chainSelect.getKeySeparator()), selection);
        }
        for (Selection selection : chainSelect.getSelections()) {
            int selectionSize = selection.getSize();
            if (!allowRootSelection && selectionSize == 0) {
                String messageStr = ComponentUtils.translate((FacesContext)context, (String)"label.chainSelect.empty_selection");
                FacesMessage message = new FacesMessage(messageStr);
                context.addMessage(clientId, message);
                chainSelect.setValid(false);
                return;
            }
            if (!allowBranchSelection && selectionSize > 0 && selectionSize != size) {
                String messageStr = ComponentUtils.translate((FacesContext)context, (String)"label.chainSelect.incomplete_selection");
                FacesMessage message = new FacesMessage(messageStr);
                context.addMessage(clientId, message);
                chainSelect.setValid(false);
                return;
            }
            map.put(selection.getValue(chainSelect.getKeySeparator()), selection);
        }
        Selection[] componentValue = map.values().toArray(new Selection[0]);
        if (componentValue.length == 0) {
            submittedValue = null;
        } else {
            submittedValue = new String[componentValue.length];
            for (int i = 0; i < componentValue.length; ++i) {
                submittedValue[i] = componentValue[i].getValue(chainSelect.getKeySeparator());
            }
        }
        chainSelect.setComponentValue(componentValue);
        chainSelect.setSubmittedValue((Object)submittedValue);
        context.renderResponse();
        log.debug((Object)("add: submittedValue=" + ChainSelect.format((Object)submittedValue)));
    }

    @Override
    public void delete(ActionEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        ChainSelect chainSelect = this.getChainSelect(event);
        ArrayList<Selection> componentValueList = new ArrayList<Selection>();
        componentValueList.addAll(Arrays.asList(chainSelect.getComponentValue()));
        String value = (String)context.getExternalContext().getRequestParameterMap().get("chainSelect_removeId");
        Iterator i = componentValueList.iterator();
        while (i.hasNext()) {
            Selection selection = (Selection)i.next();
            if (!selection.getValue(chainSelect.getKeySeparator()).equals(value)) continue;
            i.remove();
        }
        Selection[] componentValue = componentValueList.toArray(new Selection[0]);
        String[] submittedValue = null;
        if (componentValue.length != 0) {
            submittedValue = new String[componentValue.length];
            for (int i2 = 0; i2 < componentValue.length; ++i2) {
                submittedValue[i2] = componentValue[i2].getValue(chainSelect.getKeySeparator());
            }
        }
        chainSelect.setComponentValue(componentValue);
        chainSelect.setSubmittedValue((Object)submittedValue);
        context.renderResponse();
    }
}

