/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.web.listener.ejb;

import java.util.Locale;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;

public class RelationCreationBean {
    private static final Log log = LogFactory.getLog(RelationCreationBean.class);

    public void validateObject(FacesContext context, UIComponent component, Object value) {
        FacesMessage message;
        Map attributes = component.getAttributes();
        String objectTypeInputId = (String)attributes.get("objectTypeInputId");
        String objectLiteralValueInputId = (String)attributes.get("objectLiteralValueInputId");
        String objectUriInputId = (String)attributes.get("objectUriInputId");
        String objectDocumentUidInputId = (String)attributes.get("objectDocumentUidInputId");
        if (StringUtils.isBlank((String)objectTypeInputId) || StringUtils.isBlank((String)objectLiteralValueInputId) || StringUtils.isBlank((String)objectUriInputId) || StringUtils.isBlank((String)objectDocumentUidInputId)) {
            log.error((Object)"Cannot validate relation creation: input id(s) not found");
            return;
        }
        UIInput objectTypeInput = (UIInput)component.findComponent(objectTypeInputId);
        UIInput objectLiteralValueInput = (UIInput)component.findComponent(objectLiteralValueInputId);
        UIInput objectUriInput = (UIInput)component.findComponent(objectUriInputId);
        UIInput objectDocumentUidInput = (UIInput)component.findComponent(objectDocumentUidInputId);
        if (objectTypeInput == null || objectLiteralValueInput == null || objectUriInput == null || objectDocumentUidInput == null) {
            log.error((Object)"Cannot validate relation creation: input(s) not found");
            return;
        }
        String objectType = (String)objectTypeInput.getLocalValue();
        String objectValue = null;
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        if (objectType == null) {
            String msg = I18NUtils.getMessageString((String)bundleName, (String)"error.relation.required.object.type", null, (Locale)locale);
            message = new FacesMessage(msg);
        } else if (objectType.equals("literal")) {
            objectValue = StringUtils.trim((String)((String)objectLiteralValueInput.getLocalValue()));
            String msg = I18NUtils.getMessageString((String)bundleName, (String)"error.relation.required.object.text", null, (Locale)locale);
            message = new FacesMessage(msg);
        } else if (objectType.equals("uri")) {
            objectValue = StringUtils.trim((String)((String)objectUriInput.getLocalValue()));
            String msg = I18NUtils.getMessageString((String)bundleName, (String)"error.relation.required.object.uri", null, (Locale)locale);
            message = new FacesMessage(msg);
        } else if (objectType.equals("document")) {
            objectValue = StringUtils.trim((String)((String)objectDocumentUidInput.getLocalValue()));
            String msg = I18NUtils.getMessageString((String)bundleName, (String)"error.relation.required.object.document", null, (Locale)locale);
            message = new FacesMessage(msg);
        } else {
            String msg = I18NUtils.getMessageString((String)bundleName, (String)"error.relation.invalid.object.type", null, (Locale)locale);
            message = new FacesMessage(msg);
        }
        if (objectValue == null || objectValue.length() == 0) {
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            throw new ValidatorException(message);
        }
    }
}

