/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.shield;

import java.io.IOException;
import javax.faces.application.Application;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.mock.MockExternalContext;
import org.jboss.seam.mock.MockFacesContext;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.service.ExceptionHandlingListener;
import org.nuxeo.ecm.webapp.shield.MockApplication;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class SeamExceptionHandlingListener
implements ExceptionHandlingListener {
    private static final Log log = LogFactory.getLog(SeamExceptionHandlingListener.class);

    public void beforeSetErrorPageAttribute(Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String SEAM_TX_SYNCS = "org.jboss.seam.transaction.synchronizations";
        Object syncs = null;
        if (Contexts.isEventContextActive()) {
            syncs = Contexts.getEventContext().get(SEAM_TX_SYNCS);
        }
        Lifecycle.endRequest();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            MockFacesContext mockContext = this.createFacesContext(request, response);
            mockContext.setCurrent();
            facesContext = mockContext;
            log.debug((Object)"Created mock faces context for exception handling");
        } else {
            log.debug((Object)"Using existing faces context for exception handling");
        }
        FacesLifecycle.beginExceptionRecovery((ExternalContext)facesContext.getExternalContext());
        if (syncs != null) {
            Contexts.getEventContext().set(SEAM_TX_SYNCS, syncs);
        }
    }

    public void beforeForwardToErrorPage(Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    }

    public void startHandling(Throwable t, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (TransactionHelper.isTransactionActive()) {
            TransactionHelper.setTransactionRollbackOnly();
        }
    }

    public void afterDispatch(Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context instanceof MockFacesContext) {
            FacesLifecycle.endRequest((ExternalContext)context.getExternalContext());
            context.release();
        }
    }

    protected MockFacesContext createFacesContext(HttpServletRequest request, HttpServletResponse response) {
        MockFacesContext mockFacesContext = new MockFacesContext((ExternalContext)new MockExternalContext(request.getSession().getServletContext(), request, response), (Application)new MockApplication());
        mockFacesContext.setViewRoot(new UIViewRoot());
        return mockFacesContext;
    }

    public void responseComplete() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            facesContext.responseComplete();
        } else {
            log.error((Object)"Cannot set response complete: faces context is null");
        }
    }
}

