/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.jsf;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.web.resources.api.Resource;
import org.nuxeo.ecm.web.resources.api.ResourceType;
import org.nuxeo.ecm.web.resources.jsf.AbstractResourceRenderer;

public class ResourceRenderer
extends AbstractResourceRenderer {
    private static final Log log = LogFactory.getLog(ResourceRenderer.class);

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Resource resource = null;
        String url = null;
        Map attributes = component.getAttributes();
        String name = (String)attributes.get("name");
        if (name != null) {
            resource = this.resolveNuxeoResource(context, component, name);
            if (resource == null) {
                log.error((Object)("Resource not found: " + name));
                return;
            }
            url = this.getUrlWithParams(context, component, this.resolveNuxeoResourceUrl(context, component, this.resolveNuxeoResourcePath(resource)));
            url = this.resolveUrlWithTimestamp(component, url);
        }
        ResponseWriter writer = context.getResponseWriter();
        if (ResourceType.css.matches(resource)) {
            writer.startElement("link", component);
            writer.writeAttribute("type", (Object)"text/css", "type");
            writer.writeAttribute("rel", (Object)"stylesheet", "rel");
            writer.writeURIAttribute("href", (Object)url, "href");
            writer.endElement("link");
        } else if (ResourceType.js.matches(resource)) {
            writer.startElement("script", component);
            writer.writeAttribute("type", (Object)"text/javascript", "type");
            writer.writeURIAttribute("src", (Object)url, "src");
            writer.endElement("script");
        } else if (ResourceType.html.matches(resource)) {
            writer.startElement("link", component);
            writer.writeAttribute("rel", (Object)"import", "rel");
            writer.writeURIAttribute("href", (Object)url, "href");
            writer.endElement("link");
        } else {
            log.error((Object)("Unhandled type for resource " + resource));
        }
    }

    @Override
    protected void startElement(ResponseWriter writer, UIComponent component) throws IOException {
    }

    @Override
    protected void endElement(ResponseWriter writer) throws IOException {
    }
}

