/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.gwt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.util.EJB;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.remoting.gwt.gwtToSeamAdapter")
@BypassInterceptors
@Install(precedence=0)
public class GWTToSeamAdapter {
    private final Map METHOD_CACHE = new HashMap();

    public static GWTToSeamAdapter instance() {
        GWTToSeamAdapter adapter = (GWTToSeamAdapter)Component.getInstance(GWTToSeamAdapter.class);
        if (adapter == null) {
            throw new IllegalStateException("No GWTToSeamAdapter exists");
        }
        return adapter;
    }

    public ReturnedObject callWebRemoteMethod(String serviceIntfName, String methodName, Class[] paramTypes, Object[] args) throws InvocationTargetException, IllegalAccessException, SecurityException {
        Component component = Component.forName((String)serviceIntfName);
        if (component == null) {
            throw new RuntimeException("No such component: " + serviceIntfName);
        }
        Object instance = this.getServiceComponent(serviceIntfName);
        Class clz = null;
        if (component.getType().isSessionBean() && component.getBusinessInterfaces().size() > 0) {
            for (Class c : component.getBusinessInterfaces()) {
                if (!c.isAnnotationPresent(EJB.LOCAL)) continue;
                clz = c;
                break;
            }
            if (clz == null) {
                throw new RuntimeException(String.format("Type cannot be determined for component [%s]. Please ensure that it has a local interface.", component));
            }
        }
        if (clz == null) {
            clz = component.getBeanClass();
        }
        Method method = this.getMethod(serviceIntfName, methodName, clz, paramTypes);
        Object result = method.invoke(instance, args);
        return new ReturnedObject(method.getReturnType(), result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getMethod(String serviceName, String methodName, Class clz, Class[] paramTypes) {
        String key = this.getKey(serviceName, methodName, paramTypes);
        if (this.METHOD_CACHE.containsKey(key)) {
            return (Method)this.METHOD_CACHE.get(key);
        }
        try {
            Map map = this.METHOD_CACHE;
            synchronized (map) {
                Method m = this.findMethod(clz, methodName, paramTypes);
                if (m == null) {
                    throw new NoSuchMethodException();
                }
                this.METHOD_CACHE.put(key, m);
                return m;
            }
        }
        catch (NoSuchMethodException e) {
            throw new SecurityException("Unable to access a service method called [" + methodName + "] on class [" + clz.getName() + "] without the @WebRemote attribute. " + "This may be a hack attempt, or someone simply neglected to use the @WebRemote attribute to indicate a method as" + " remotely accessible.");
        }
    }

    private String getKey(String serviceName, String methodName, Class[] paramTypes) {
        if (paramTypes == null) {
            return serviceName + "." + methodName;
        }
        String pTypes = "";
        for (int i = 0; i < paramTypes.length; ++i) {
            pTypes = pTypes + paramTypes[i].getName();
        }
        return serviceName + "." + methodName + "(" + pTypes + ")";
    }

    private Method findMethod(Class clz, String methodName, Class[] paramTypes) throws NoSuchMethodException {
        if (clz == Object.class) {
            return null;
        }
        Method m = clz.getMethod(methodName, paramTypes);
        if (this.isWebRemoteAnnotated(m)) {
            return m;
        }
        return this.findMethod(clz.getSuperclass(), methodName, paramTypes);
    }

    private boolean isWebRemoteAnnotated(Method method) {
        if (method == null) {
            return false;
        }
        return method.getAnnotation(WebRemote.class) != null;
    }

    protected Object getServiceComponent(String serviceIntfName) {
        return Component.getInstance((String)serviceIntfName);
    }

    static class ReturnedObject {
        public Class returnType;
        public Object returnedObject;

        public ReturnedObject(Class type, Object result) {
            this.returnType = type;
            this.returnedObject = result;
        }
    }
}

