/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.web.listener.ejb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.audit.api.FilterMapEntry;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.Logs;
import org.nuxeo.ecm.platform.audit.api.comment.CommentProcessorHelper;
import org.nuxeo.ecm.platform.audit.api.comment.LinkedDocument;
import org.nuxeo.ecm.platform.audit.web.listener.ContentHistoryActions;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.runtime.api.Framework;

@Name(value="contentHistoryActions")
@Scope(value=ScopeType.EVENT)
public class ContentHistoryActionsBean
implements ContentHistoryActions {
    private static final long serialVersionUID = -6110545879809627627L;
    private static final String EVENT_DATE = "eventDate";
    private static final Log log = LogFactory.getLog(ContentHistoryActionsBean.class);
    protected List<LogEntry> logEntries;
    private Map<Long, String> logEntriesComments;
    private Map<Long, LinkedDocument> logEntriesLinkedDocs;
    private List<LogEntry> latestLogEntries;
    protected final int nbLogEntries = 5;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    private transient NavigationContext navigationContext;
    @RequestParameter(value="sortColumn")
    protected String newSortColumn;
    protected SortInfo sortInfo;
    protected Map<String, FilterMapEntry> filterMap = Collections.emptyMap();
    protected Comparator<LogEntry> comparator;

    public ContentHistoryActionsBean() {
        this.sortInfo = new SortInfo(EVENT_DATE, false);
    }

    @Factory(value="latestLogEntries", scope=ScopeType.EVENT)
    public List<LogEntry> computeLatestLogEntries() {
        if (this.latestLogEntries == null) {
            if (this.logEntries == null) {
                this.logEntries = this.computeLogEntries(this.navigationContext.getCurrentDocument());
            }
            if (this.logEntries != null) {
                this.latestLogEntries = this.logEntries.size() > 5 ? new ArrayList<LogEntry>(this.logEntries.subList(0, 5)) : this.logEntries;
            }
        }
        return this.latestLogEntries;
    }

    @Factory(value="logEntries", scope=ScopeType.EVENT)
    public List<LogEntry> computeLogEntries() {
        if (this.logEntries == null) {
            this.logEntries = this.computeLogEntries(this.navigationContext.getCurrentDocument());
        }
        return this.logEntries;
    }

    @Override
    @Factory(value="logEntriesComments", scope=ScopeType.EVENT)
    public Map<Long, String> computeLogEntriesComments() {
        if (this.logEntriesComments == null) {
            this.computeLogEntries();
            this.postProcessComments(this.logEntries);
        }
        return this.logEntriesComments;
    }

    @Override
    @Factory(value="logEntriesLinkedDocs", scope=ScopeType.EVENT)
    public Map<Long, LinkedDocument> computeLogEntrieslinkedDocs() {
        if (this.logEntriesLinkedDocs == null) {
            this.computeLogEntries();
            this.postProcessComments(this.logEntries);
        }
        return this.logEntriesLinkedDocs;
    }

    public List<LogEntry> computeLogEntries(DocumentModel document) {
        boolean doDefaultSort;
        Logs service;
        if (document == null) {
            return null;
        }
        Logs logsBean = service = (Logs)Framework.getService(Logs.class);
        boolean bl = doDefaultSort = this.comparator == null;
        if (document.isProxy()) {
            GetVersionInfoForDocumentRunner runner = new GetVersionInfoForDocumentRunner(this.documentManager, document);
            runner.runUnrestricted();
            if (runner.sourceDocForVersionId == null || runner.version == null) {
                String message = "An error occurred while grabbing log entries for " + document.getId();
                throw new NuxeoException(message);
            }
            Date versionCreationDate = this.getCreationDateForVersion(logsBean, runner.version);
            this.addLogEntries(this.getLogsForDocUntilDate(logsBean, runner.sourceDocForVersionId, versionCreationDate, doDefaultSort));
            List<LogEntry> publishingLogs = this.getLogsForDocUntilDateWithEvent(logsBean, runner.sourceDocForVersionId, versionCreationDate, "documentPublished", doDefaultSort);
            if (!publishingLogs.isEmpty()) {
                this.addLogEntry(publishingLogs.get(0));
            }
            this.filterMap = new HashMap<String, FilterMapEntry>();
            this.addLogEntries(logsBean.getLogEntriesFor(runner.version.getId(), this.filterMap, doDefaultSort));
        } else {
            this.addLogEntries(logsBean.getLogEntriesFor(document.getId(), this.filterMap, doDefaultSort));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"logEntries computed .................!");
        }
        return this.logEntries;
    }

    @Override
    public String doSearch() {
        if (StringUtils.isEmpty((String)this.newSortColumn)) {
            this.newSortColumn = EVENT_DATE;
        }
        String sortColumn = this.sortInfo.getSortColumn();
        boolean sortAscending = this.sortInfo.getSortAscending();
        if (this.newSortColumn.equals(sortColumn)) {
            sortAscending = !sortAscending;
        } else {
            sortColumn = this.newSortColumn;
            sortAscending = true;
        }
        this.sortInfo = new SortInfo(sortColumn, sortAscending);
        this.logEntries = null;
        return null;
    }

    private void postProcessComments(List<LogEntry> logEntries) {
        this.logEntriesComments = new HashMap<Long, String>();
        this.logEntriesLinkedDocs = new HashMap<Long, LinkedDocument>();
        CommentProcessorHelper cph = new CommentProcessorHelper(this.documentManager);
        if (logEntries == null) {
            return;
        }
        for (LogEntry entry : logEntries) {
            this.logEntriesComments.put(entry.getId(), cph.getLogComment(entry));
            LinkedDocument linkedDoc = cph.getLogLinkedDocument(entry);
            if (linkedDoc == null) continue;
            this.logEntriesLinkedDocs.put(entry.getId(), linkedDoc);
        }
    }

    @Override
    public SortInfo getSortInfo() {
        return this.sortInfo;
    }

    private Date getCreationDateForVersion(Logs logsService, DocumentModel version) {
        List logs = logsService.getLogEntriesFor(version.getId(), this.filterMap, true);
        for (LogEntry logEntry : logs) {
            if (!logEntry.getEventId().equals("documentCreated")) continue;
            return logEntry.getEventDate();
        }
        return null;
    }

    private void addLogEntries(List<LogEntry> entries) {
        if (this.logEntries != null) {
            this.logEntries.addAll(entries);
        } else {
            this.logEntries = entries;
        }
    }

    private void addLogEntry(LogEntry entry) {
        if (this.logEntries != null) {
            this.logEntries.add(entry);
        } else {
            this.logEntries = new ArrayList<LogEntry>();
            this.logEntries.add(entry);
        }
    }

    private static FilterMapEntry computeQueryForLogsOnDocUntilDate(Date date) {
        FilterMapEntry filterByDate = new FilterMapEntry();
        filterByDate.setColumnName(EVENT_DATE);
        filterByDate.setOperator("<=");
        filterByDate.setQueryParameterName(EVENT_DATE);
        filterByDate.setObject((Object)date);
        return filterByDate;
    }

    private static FilterMapEntry computeQueryForLogsOnDocAfterDate(Date date) {
        FilterMapEntry filterByDate = new FilterMapEntry();
        filterByDate.setColumnName(EVENT_DATE);
        filterByDate.setOperator(">=");
        filterByDate.setQueryParameterName(EVENT_DATE);
        filterByDate.setObject((Object)date);
        return filterByDate;
    }

    private static FilterMapEntry computeQueryForLogsWithEvent(String eventName) {
        FilterMapEntry filterByDate = new FilterMapEntry();
        filterByDate.setColumnName("eventId");
        filterByDate.setOperator("LIKE");
        filterByDate.setQueryParameterName("eventId");
        filterByDate.setObject((Object)eventName);
        return filterByDate;
    }

    private List<LogEntry> getLogsForDocUntilDate(Logs logsService, String docId, Date date, boolean doDefaultSort) {
        this.filterMap = new HashMap<String, FilterMapEntry>();
        this.filterMap.put(EVENT_DATE, ContentHistoryActionsBean.computeQueryForLogsOnDocUntilDate(date));
        return logsService.getLogEntriesFor(docId, this.filterMap, doDefaultSort);
    }

    private List<LogEntry> getLogsForDocUntilDateWithEvent(Logs logsService, String docId, Date date, String eventName, boolean doDefaultSort) {
        this.filterMap = new HashMap<String, FilterMapEntry>();
        this.filterMap.put(EVENT_DATE, ContentHistoryActionsBean.computeQueryForLogsOnDocAfterDate(date));
        this.filterMap.put("eventId", ContentHistoryActionsBean.computeQueryForLogsWithEvent(eventName));
        return logsService.getLogEntriesFor(docId, this.filterMap, doDefaultSort);
    }

    private class GetVersionInfoForDocumentRunner
    extends UnrestrictedSessionRunner {
        public String sourceDocForVersionId;
        public DocumentModel version;
        DocumentModel document;

        public GetVersionInfoForDocumentRunner(CoreSession session, DocumentModel document) {
            super(session);
            this.document = document;
        }

        public void run() {
            this.version = ContentHistoryActionsBean.this.documentManager.getSourceDocument(this.document.getRef());
            if (this.version != null) {
                this.sourceDocForVersionId = this.session.getSourceDocument(this.version.getRef()).getId();
            }
        }
    }
}

