/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.renderkit;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.ui.component.UIDecorate;
import org.jboss.seam.ui.component.UIDecorateAware;
import org.jboss.seam.ui.util.Decoration;
import org.jboss.seam.ui.util.cdk.RendererBase;

public class DecorateRendererBase
extends RendererBase {
    private Map<String, Object> originalValues = new HashMap<String, Object>();
    String[] storeOriginals = new String[]{"invalid", "required"};

    @Override
    protected Class getComponentClass() {
        return UIDecorate.class;
    }

    private static void setUIDecorate(UIComponent component, UIDecorate decorator) {
        if (component instanceof UIDecorateAware) {
            ((UIDecorateAware)component).setUIDecorate(decorator);
        }
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIComponent)) continue;
            DecorateRendererBase.setUIDecorate(child, decorator);
        }
    }

    private void storeOriginalValues(String[] names, Context context) {
        for (String name : names) {
            if (!context.isSet(name)) continue;
            this.originalValues.put(name, context.get(name));
        }
    }

    private void restoreOriginalValues(String[] names, Context context) {
        for (String name : names) {
            if (this.originalValues.containsKey(name)) {
                context.set(name, this.originalValues.get(name));
                continue;
            }
            context.remove(name);
        }
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIDecorate decorate = (UIDecorate)component;
        this.storeOriginalValues(this.storeOriginals, Contexts.getEventContext());
        Contexts.getEventContext().set("invalid", (Object)Decoration.hasMessage((UIComponent)decorate, context));
        Contexts.getEventContext().set("required", (Object)Decoration.hasRequired(component, context));
        boolean hasMessage = decorate.hasMessage();
        if (decorate.isEnclose()) {
            writer.startElement(decorate.getElement(), (UIComponent)decorate);
            if (decorate.getStyleClass() != null) {
                writer.writeAttribute("class", (Object)decorate.getStyleClass(), "class");
            }
            if (decorate.getStyle() != null) {
                writer.writeAttribute("style", (Object)decorate.getStyle(), "style");
            }
            writer.writeAttribute("id", (Object)decorate.getClientId(context), "id");
        }
        UIComponent aroundDecoration = decorate.getDecoration("aroundField");
        UIComponent aroundInvalidDecoration = decorate.getDecoration("aroundInvalidField");
        if (aroundDecoration != null && !hasMessage) {
            DecorateRendererBase.setUIDecorate(aroundDecoration, decorate);
            aroundDecoration.encodeBegin(context);
        }
        if (aroundInvalidDecoration != null && hasMessage) {
            DecorateRendererBase.setUIDecorate(aroundInvalidDecoration, decorate);
            aroundInvalidDecoration.encodeBegin(context);
        }
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIDecorate decorate = (UIDecorate)component;
        boolean hasMessage = decorate.hasMessage();
        UIComponent aroundDecoration = decorate.getDecoration("aroundField");
        UIComponent aroundInvalidDecoration = decorate.getDecoration("aroundInvalidField");
        if (aroundDecoration != null && !hasMessage) {
            DecorateRendererBase.setUIDecorate(aroundDecoration, decorate);
            aroundDecoration.encodeEnd(context);
        }
        if (aroundInvalidDecoration != null && hasMessage) {
            DecorateRendererBase.setUIDecorate(aroundInvalidDecoration, decorate);
            aroundInvalidDecoration.encodeEnd(context);
        }
        if (decorate.isEnclose()) {
            context.getResponseWriter().endElement(decorate.getElement());
        }
        this.restoreOriginalValues(this.storeOriginals, Contexts.getEventContext());
    }

    @Override
    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIDecorate decorate = (UIDecorate)component;
        boolean hasMessage = decorate.hasMessage();
        UIComponent beforeDecoration = decorate.getDecoration("beforeField");
        UIComponent beforeInvalidDecoration = decorate.getDecoration("beforeInvalidField");
        if (beforeDecoration != null && !hasMessage) {
            DecorateRendererBase.setUIDecorate(beforeDecoration, decorate);
            this.renderChild(context, beforeDecoration);
        }
        if (beforeInvalidDecoration != null && hasMessage) {
            DecorateRendererBase.setUIDecorate(beforeInvalidDecoration, decorate);
            this.renderChild(context, beforeInvalidDecoration);
        }
        this.renderChildren(context, (UIComponent)decorate);
        UIComponent afterDecoration = decorate.getDecoration("afterField");
        UIComponent afterInvalidDecoration = decorate.getDecoration("afterInvalidField");
        if (afterDecoration != null && !hasMessage) {
            DecorateRendererBase.setUIDecorate(afterDecoration, decorate);
            this.renderChild(context, afterDecoration);
        }
        if (afterInvalidDecoration != null && hasMessage) {
            DecorateRendererBase.setUIDecorate(afterInvalidDecoration, decorate);
            this.renderChild(context, afterInvalidDecoration);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }
}

