/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.graphic;

import com.lowagie.text.DocWriter;
import com.lowagie.text.rtf.RtfAddableElement;
import java.io.IOException;
import java.io.OutputStream;

public class RtfShapePosition
extends RtfAddableElement {
    public static final int POSITION_X_RELATIVE_PAGE = 0;
    public static final int POSITION_X_RELATIVE_MARGIN = 1;
    public static final int POSITION_X_RELATIVE_COLUMN = 2;
    public static final int POSITION_Y_RELATIVE_PAGE = 0;
    public static final int POSITION_Y_RELATIVE_MARGIN = 1;
    public static final int POSITION_Y_RELATIVE_PARAGRAPH = 2;
    private int top = 0;
    private int left = 0;
    private int right = 0;
    private int bottom = 0;
    private int zOrder = 0;
    private int xRelativePos = 0;
    private int yRelativePos = 0;
    private boolean ignoreXRelative = false;
    private boolean ignoreYRelative = false;
    private boolean shapeBelowText = false;

    public RtfShapePosition(int top, int left, int right, int bottom) {
        this.top = top;
        this.left = left;
        this.right = right;
        this.bottom = bottom;
    }

    public boolean isShapeBelowText() {
        return this.shapeBelowText;
    }

    public void setShapeBelowText(boolean shapeBelowText) {
        this.shapeBelowText = shapeBelowText;
    }

    public void setXRelativePos(int relativePos) {
        this.xRelativePos = relativePos;
    }

    public void setYRelativePos(int relativePos) {
        this.yRelativePos = relativePos;
    }

    public void setZOrder(int order) {
        this.zOrder = order;
    }

    protected void setIgnoreXRelative(boolean ignoreXRelative) {
        this.ignoreXRelative = ignoreXRelative;
    }

    protected void setIgnoreYRelative(boolean ignoreYRelative) {
        this.ignoreYRelative = ignoreYRelative;
    }

    @Override
    public void writeContent(OutputStream result) throws IOException {
        result.write(DocWriter.getISOBytes((String)"\\shpleft"));
        result.write(this.intToByteArray(this.left));
        result.write(DocWriter.getISOBytes((String)"\\shptop"));
        result.write(this.intToByteArray(this.top));
        result.write(DocWriter.getISOBytes((String)"\\shpright"));
        result.write(this.intToByteArray(this.right));
        result.write(DocWriter.getISOBytes((String)"\\shpbottom"));
        result.write(this.intToByteArray(this.bottom));
        result.write(DocWriter.getISOBytes((String)"\\shpz"));
        result.write(this.intToByteArray(this.zOrder));
        switch (this.xRelativePos) {
            case 0: {
                result.write(DocWriter.getISOBytes((String)"\\shpbxpage"));
                break;
            }
            case 1: {
                result.write(DocWriter.getISOBytes((String)"\\shpbxmargin"));
                break;
            }
            case 2: {
                result.write(DocWriter.getISOBytes((String)"\\shpbxcolumn"));
            }
        }
        if (this.ignoreXRelative) {
            result.write(DocWriter.getISOBytes((String)"\\shpbxignore"));
        }
        switch (this.yRelativePos) {
            case 0: {
                result.write(DocWriter.getISOBytes((String)"\\shpbypage"));
                break;
            }
            case 1: {
                result.write(DocWriter.getISOBytes((String)"\\shpbymargin"));
                break;
            }
            case 2: {
                result.write(DocWriter.getISOBytes((String)"\\shpbypara"));
            }
        }
        if (this.ignoreYRelative) {
            result.write(DocWriter.getISOBytes((String)"\\shpbyignore"));
        }
        if (this.shapeBelowText) {
            result.write(DocWriter.getISOBytes((String)"\\shpfblwtxt1"));
        } else {
            result.write(DocWriter.getISOBytes((String)"\\shpfblwtxt0"));
        }
    }
}

