/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2Client;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2ClientService;
import org.nuxeo.ecm.platform.oauth2.tokens.OAuth2TokenStore;
import org.nuxeo.runtime.api.Framework;

@Name(value="authorizedApplicationsActions")
@Scope(value=ScopeType.CONVERSATION)
public class AuthorizedApplicationsActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In
    protected NuxeoPrincipal currentUser;

    public List<Map<String, Serializable>> getOAuth2AuthorizedApplications() {
        ArrayList<Map<String, Serializable>> applications = new ArrayList<Map<String, Serializable>>();
        OAuth2ClientService clientService = (OAuth2ClientService)Framework.getService(OAuth2ClientService.class);
        OAuth2TokenStore tokenStore = new OAuth2TokenStore("org.nuxeo.server.token.store");
        DocumentModelList tokens = tokenStore.query(this.getOAuth2QueryFilter());
        for (DocumentModel token : tokens) {
            OAuth2Client client = clientService.getClient((String)((Object)token.getPropertyValue("oauth2Token:clientId")));
            if (client == null) continue;
            HashMap<String, Object> application = new HashMap<String, Object>();
            application.put("id", token.getPropertyValue("oauth2Token:id"));
            application.put("applicationId", client.getId());
            application.put("applicationName", client.getName());
            Calendar creationDate = (Calendar)token.getPropertyValue("oauth2Token:creationDate");
            if (creationDate != null) {
                application.put("applicationAuthorizationDate", creationDate.getTime());
            }
            applications.add(application);
        }
        return applications;
    }

    public DocumentModelList getOAuthAuthorizedApplications() {
        DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        return (DocumentModelList)Framework.doPrivileged(() -> {
            try (Session session = directoryService.open("oauthTokens");){
                Map<String, Serializable> queryFilter = this.getOAuthQueryFilter();
                DocumentModelList documentModelList = session.query(queryFilter);
                return documentModelList;
            }
        });
    }

    protected Map<String, Serializable> getOAuth2QueryFilter() {
        HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
        filter.put("nuxeoLogin", (Serializable)((Object)this.currentUser.getName()));
        return filter;
    }

    protected Map<String, Serializable> getOAuthQueryFilter() {
        HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
        filter.put("clientToken", Integer.valueOf(0));
        filter.put("nuxeoLogin", (Serializable)((Object)this.currentUser.getName()));
        return filter;
    }

    public void revokeAccess(String directoryName, String id) {
        DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        Framework.doPrivileged(() -> {
            try (Session session = directoryService.open(directoryName);){
                session.deleteEntry(id);
            }
        });
    }
}

