/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.search.ui.seam;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewHeader;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewState;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewStateImpl;
import org.nuxeo.ecm.platform.contentview.json.JSONContentViewState;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.rest.RestHelper;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.webapp.action.ActionContextProvider;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.search.ui.SearchUIService;

@Name(value="searchUIActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class SearchUIActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SearchUIActions.class);
    public static final String SAVED_SEARCHES_LABEL = "label.saved.searches";
    public static final String SHARED_SEARCHES_LABEL = "label.shared.searches";
    public static final String SEARCH_FILTERS_LABEL = "label.search.filters";
    public static final String SEARCH_SAVED_LABEL = "label.search.saved";
    public static final String MAIN_TABS_SEARCH = "MAIN_TABS:search";
    public static final String SEARCH_VIEW_ID = "/search/search.xhtml";
    public static final String SEARCH_CODEC = "docpathsearch";
    public static final String SIMPLE_SEARCH_CONTENT_VIEW_NAME = "simple_search";
    public static final String NXQL_SEARCH_CONTENT_VIEW_NAME = "nxql_search";
    public static final String DEFAULT_NXQL_QUERY = "SELECT * FROM Document WHERE ecm:mixinType != 'HiddenInNavigation' AND ecm:isProxy = 0 AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'";
    public static final String CONTENT_VIEW_NAME_PARAMETER = "contentViewName";
    public static final String CURRENT_PAGE_PARAMETER = "currentPage";
    public static final String PAGE_SIZE_PARAMETER = "pageSize";
    public static final String CONTENT_VIEW_STATE_PARAMETER = "state";
    public static final String SEARCH_TERM_PARAMETER = "searchTerm";
    public static final String SEARCH_SELECTED_EVENT = "searchSelected";
    public static final String SEARCH_SAVED_EVENT = "searchSaved";
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient ActionContextProvider actionContextProvider;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true)
    protected RestHelper restHelper;
    @In(create=true)
    protected ContentViewActions contentViewActions;
    @In(create=true)
    protected ContentViewService contentViewService;
    @In(create=true)
    protected DocumentsListsManager documentsListsManager;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    protected String simpleSearchKeywords = "";
    protected String nxqlQuery = "SELECT * FROM Document WHERE ecm:mixinType != 'HiddenInNavigation' AND ecm:isProxy = 0 AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'";
    protected List<ContentViewHeader> contentViewHeaders;
    protected String currentContentViewName;
    protected String currentSelectedSavedSearchId;
    protected String currentPage;
    protected String pageSize;
    protected String searchTerm;
    protected String savedSearchTitle;

    public String getSearchMainTab() {
        return MAIN_TABS_SEARCH;
    }

    public void setSearchMainTab(String tabs) {
        this.webActions.setCurrentTabIds(!StringUtils.isBlank((String)tabs) ? tabs : MAIN_TABS_SEARCH);
    }

    public String getSearchViewTitle() {
        if (this.currentSelectedSavedSearchId != null) {
            DocumentModel savedSearch = this.documentManager.getDocument((DocumentRef)new IdRef(this.currentSelectedSavedSearchId));
            return savedSearch.getTitle();
        }
        if (this.currentContentViewName != null) {
            ContentView cv = this.contentViewActions.getContentView(this.currentContentViewName);
            String title = cv.getTranslateTitle() ? this.messages.get(cv.getTitle()) : cv.getTitle();
            return StringUtils.isNotBlank((String)title) ? title : this.currentContentViewName;
        }
        return null;
    }

    public boolean isOnSearchView() {
        String viewId;
        if (FacesContext.getCurrentInstance() == null) {
            return false;
        }
        UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
        return viewRoot != null && SEARCH_VIEW_ID.equals(viewId = viewRoot.getViewId());
    }

    public String getJSONContentViewState() throws UnsupportedEncodingException {
        ContentView contentView = this.contentViewActions.getContentView(this.currentContentViewName);
        ContentViewService contentViewService = (ContentViewService)Framework.getService(ContentViewService.class);
        ContentViewState state = contentViewService.saveContentView(contentView);
        return JSONContentViewState.toJSON((ContentViewState)state, (boolean)true);
    }

    public String getCurrentContentViewName() {
        List<ContentViewHeader> contentViewHeaders;
        if (this.currentContentViewName == null && !(contentViewHeaders = this.getContentViewHeaders()).isEmpty()) {
            this.currentContentViewName = contentViewHeaders.get(0).getName();
        }
        return this.currentContentViewName;
    }

    public void setCurrentContentViewName(String contentViewName) {
        this.currentContentViewName = contentViewName;
    }

    public String getCurrentSelectedSavedSearchId() {
        return this.currentSelectedSavedSearchId != null ? this.currentSelectedSavedSearchId : this.currentContentViewName;
    }

    public void setCurrentSelectedSavedSearchId(String selectedSavedSearchId) throws UnsupportedEncodingException {
        this.resetCurrentContentViewWorkingList();
        for (ContentViewHeader contentViewHeader : this.contentViewHeaders) {
            if (!contentViewHeader.getName().equals(selectedSavedSearchId)) continue;
            this.contentViewActions.reset(this.currentContentViewName);
            this.currentContentViewName = selectedSavedSearchId;
            Events.instance().raiseEvent(SEARCH_SELECTED_EVENT, new Object[]{this.currentContentViewName});
            this.currentSelectedSavedSearchId = null;
            return;
        }
        DocumentModel savedSearch = this.documentManager.getDocument((DocumentRef)new IdRef(selectedSavedSearchId));
        this.loadSavedSearch(savedSearch);
    }

    protected void resetCurrentContentViewWorkingList() {
        ContentView contentView;
        if (this.currentContentViewName != null && (contentView = this.contentViewActions.getContentView(this.currentContentViewName)) != null) {
            this.documentsListsManager.resetWorkingList(contentView.getSelectionListName());
        }
    }

    public void loadSavedSearch(DocumentModel searchDocument) throws UnsupportedEncodingException {
        SearchUIService searchUIService = (SearchUIService)Framework.getService(SearchUIService.class);
        ContentViewState contentViewState = searchUIService.loadSearch(searchDocument);
        if (contentViewState != null) {
            ContentView contentView = this.contentViewActions.restoreContentView(contentViewState);
            this.currentContentViewName = contentView.getName();
            Events.instance().raiseEvent(SEARCH_SELECTED_EVENT, new Object[]{this.currentContentViewName});
        }
        this.currentSelectedSavedSearchId = searchDocument.getId();
    }

    public List<ContentViewHeader> getContentViewHeaders() {
        if (this.contentViewHeaders == null) {
            SearchUIService searchUIService = (SearchUIService)Framework.getService(SearchUIService.class);
            this.contentViewHeaders = searchUIService.getContentViewHeaders(this.actionContextProvider.createActionContext(), this.navigationContext.getCurrentDocument());
        }
        return this.contentViewHeaders;
    }

    public void clearSearch() {
        if (this.currentContentViewName != null) {
            this.contentViewActions.reset(this.currentContentViewName);
            this.resetCurrentContentViewWorkingList();
        }
    }

    public void refreshAndRewind() {
        String contentViewName = this.getCurrentContentViewName();
        if (contentViewName != null) {
            this.contentViewActions.refreshAndRewind(contentViewName);
            this.resetCurrentContentViewWorkingList();
        }
    }

    public void refreshAndRewindAndResetAggregates() {
        this.contentViewActions.resetAggregates(this.getCurrentContentViewName());
        this.refreshAndRewind();
    }

    public List<SelectItem> getAllSavedSearchesSelectItems() {
        List<DocumentModel> otherUsersSavedFacetedSearches;
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        SelectItemGroup flaggedGroup = new SelectItemGroup(this.messages.get(SEARCH_FILTERS_LABEL));
        List<ContentViewHeader> flaggedSavedSearches = this.getContentViewHeaders();
        List<SelectItem> flaggedSavedSearchesItems = this.convertCVToSelectItems(flaggedSavedSearches);
        flaggedGroup.setSelectItems(flaggedSavedSearchesItems.toArray(new SelectItem[flaggedSavedSearchesItems.size()]));
        items.add((SelectItem)flaggedGroup);
        List<DocumentModel> userSavedSearches = this.getSavedSearches();
        if (!userSavedSearches.isEmpty()) {
            SelectItemGroup userGroup = new SelectItemGroup(this.messages.get(SAVED_SEARCHES_LABEL));
            List<SelectItem> userSavedSearchesItems = this.convertToSelectItems(userSavedSearches);
            userGroup.setSelectItems(userSavedSearchesItems.toArray(new SelectItem[userSavedSearchesItems.size()]));
            items.add((SelectItem)userGroup);
        }
        if (!(otherUsersSavedFacetedSearches = this.getSharedSearches()).isEmpty()) {
            List<SelectItem> otherUsersSavedSearchesItems = this.convertToSelectItems(otherUsersSavedFacetedSearches);
            SelectItemGroup allGroup = new SelectItemGroup(this.messages.get(SHARED_SEARCHES_LABEL));
            allGroup.setSelectItems(otherUsersSavedSearchesItems.toArray(new SelectItem[otherUsersSavedSearchesItems.size()]));
            items.add((SelectItem)allGroup);
        }
        return items;
    }

    protected List<DocumentModel> getSavedSearches() {
        SearchUIService searchUIService = (SearchUIService)Framework.getService(SearchUIService.class);
        return searchUIService.getCurrentUserSavedSearches(this.documentManager);
    }

    protected List<DocumentModel> getSharedSearches() {
        SearchUIService searchUIService = (SearchUIService)Framework.getService(SearchUIService.class);
        return searchUIService.getSharedSavedSearches(this.documentManager);
    }

    protected List<SelectItem> convertToSelectItems(List<DocumentModel> docs) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (DocumentModel doc : docs) {
            items.add(new SelectItem((Object)doc.getId(), doc.getTitle(), ""));
        }
        return items;
    }

    protected List<SelectItem> convertCVToSelectItems(List<ContentViewHeader> contentViewHeaders) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (ContentViewHeader contentViewHeader : contentViewHeaders) {
            items.add(new SelectItem((Object)contentViewHeader.getName(), this.messages.get(contentViewHeader.getTitle()), ""));
        }
        return items;
    }

    public String getSavedSearchTitle() {
        return this.savedSearchTitle;
    }

    public void setSavedSearchTitle(String savedSearchTitle) {
        this.savedSearchTitle = savedSearchTitle;
    }

    public String saveSearch() {
        ContentView contentView = this.contentViewActions.getContentView(this.getCurrentContentViewName());
        if (contentView != null) {
            ContentViewState state = this.contentViewService.saveContentView(contentView);
            SearchUIService searchUIService = (SearchUIService)Framework.getService(SearchUIService.class);
            DocumentModel savedSearch = searchUIService.saveSearch(this.documentManager, state, this.savedSearchTitle);
            this.currentSelectedSavedSearchId = savedSearch.getId();
            Events.instance().raiseEvent(SEARCH_SAVED_EVENT, new Object[]{savedSearch});
            this.savedSearchTitle = null;
            this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get(SEARCH_SAVED_LABEL), new Object[0]);
        }
        return null;
    }

    public boolean getCanSaveSearch() {
        ContentView contentView = this.contentViewActions.getContentView(this.getCurrentContentViewName());
        if (contentView != null) {
            boolean res = !contentView.isWaitForExecution() || contentView.isExecuted();
            return res;
        }
        return false;
    }

    public void cancelSaveSearch() {
        this.savedSearchTitle = null;
    }

    public void setState(String state) throws UnsupportedEncodingException {
        if (StringUtils.isNotBlank((String)state)) {
            Long finalPageSize = null;
            if (!StringUtils.isBlank((String)this.pageSize)) {
                try {
                    finalPageSize = Long.valueOf(this.pageSize);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)String.format("Unable to parse '%s' parameter with value '%s'", PAGE_SIZE_PARAMETER, this.pageSize));
                }
            }
            Long finalCurrentPage = null;
            if (!StringUtils.isBlank((String)this.currentPage)) {
                try {
                    finalCurrentPage = Long.valueOf(this.currentPage);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)String.format("Unable to parse '%s' parameter with value '%s'", CURRENT_PAGE_PARAMETER, this.currentPage));
                }
            }
            String cvName = this.getCurrentContentViewName();
            List<ContentViewHeader> contentViewHeaders = this.getContentViewHeaders();
            if (cvName != null && contentViewHeaders != null) {
                boolean canRestore = false;
                for (ContentViewHeader contentViewHeader : this.getContentViewHeaders()) {
                    if (!cvName.equals(contentViewHeader.getName())) continue;
                    canRestore = true;
                }
                if (canRestore) {
                    this.contentViewActions.restoreContentView(this.getCurrentContentViewName(), finalCurrentPage, finalPageSize, null, state);
                } else {
                    this.invalidateContentViewsName();
                }
            }
        }
    }

    public String getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(String currentPage) {
        this.currentPage = currentPage;
    }

    public String getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public void setSearchTerm(String searchTerm) throws UnsupportedEncodingException {
        if (!StringUtils.isEmpty((String)searchTerm)) {
            this.currentContentViewName = SIMPLE_SEARCH_CONTENT_VIEW_NAME;
            ContentView cv = this.contentViewService.getContentView(SIMPLE_SEARCH_CONTENT_VIEW_NAME);
            DocumentModel searchDocumentModel = cv.getSearchDocumentModel();
            searchDocumentModel.setPropertyValue("default_search:ecm_fulltext", (Serializable)((Object)searchTerm));
            ContentViewStateImpl state = new ContentViewStateImpl();
            state.setSearchDocumentModel(searchDocumentModel);
            state.setContentViewName(this.getCurrentContentViewName());
            ContentView ccv = this.contentViewActions.restoreContentView((ContentViewState)state);
            ccv.setExecuted(true);
        }
    }

    public String getSearchPermanentLinkUrl() throws UnsupportedEncodingException {
        if (this.documentManager == null) {
            return null;
        }
        return this.generateSearchUrl(true);
    }

    public String getSearchTabUrl(String searchTerm) throws UnsupportedEncodingException {
        if (this.documentManager == null) {
            return null;
        }
        this.searchTerm = searchTerm;
        return this.generateSearchUrl(false);
    }

    protected String generateSearchUrl(boolean withState) throws UnsupportedEncodingException {
        String currentContentViewName = this.getCurrentContentViewName();
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        DocumentView docView = this.computeDocumentView(currentDocument);
        docView.setViewId("search");
        docView.addParameter(CONTENT_VIEW_NAME_PARAMETER, currentContentViewName);
        if (withState) {
            docView.addParameter(CONTENT_VIEW_STATE_PARAMETER, this.getJSONContentViewState());
        }
        DocumentViewCodecManager documentViewCodecManager = (DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class);
        String url = documentViewCodecManager.getUrlFromDocumentView(SEARCH_CODEC, docView, true, BaseURL.getBaseURL());
        return RestHelper.addCurrentConversationParameters((String)url);
    }

    protected DocumentView computeDocumentView(DocumentModel doc) {
        return new DocumentViewImpl((DocumentLocation)new DocumentLocationImpl(this.documentManager.getRepositoryName(), (DocumentRef)(doc != null ? new PathRef(doc.getPathAsString()) : null)));
    }

    public String getSimpleSearchKeywords() {
        return this.simpleSearchKeywords;
    }

    public void setSimpleSearchKeywords(String simpleSearchKeywords) {
        this.simpleSearchKeywords = simpleSearchKeywords;
    }

    public void validateSimpleSearchKeywords(FacesContext context, UIComponent component, Object value) {
        String[] keywords;
        if (!(value instanceof String) || StringUtils.isEmpty((String)((String)value).trim())) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"feedback.search.noKeywords"), null);
            context.addMessage(null, message);
            throw new ValidatorException(message);
        }
        for (String keyword : keywords = ((String)value).trim().split(" ")) {
            if (!keyword.startsWith("*")) continue;
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"feedback.search.star"), null);
            context.addMessage(null, message);
            throw new ValidatorException(message);
        }
    }

    public String doSimpleSearch() {
        this.setSearchMainTab(null);
        this.currentContentViewName = SIMPLE_SEARCH_CONTENT_VIEW_NAME;
        ContentView contentView = this.contentViewActions.getContentView(SIMPLE_SEARCH_CONTENT_VIEW_NAME);
        DocumentModel searchDoc = contentView.getSearchDocumentModel();
        searchDoc.setPropertyValue("defaults:ecm_fulltext", (Serializable)((Object)this.simpleSearchKeywords));
        this.refreshAndRewind();
        return "search";
    }

    public String getNxqlQuery() {
        return this.nxqlQuery;
    }

    public void setNxqlQuery(String nxqlQuery) {
        this.nxqlQuery = nxqlQuery;
    }

    public boolean isNxqlSearchSelected() {
        return NXQL_SEARCH_CONTENT_VIEW_NAME.equals(this.currentContentViewName);
    }

    @Begin(id="#{conversationIdGenerator.currentOrNewMainConversationId}", join=true)
    public String loadPermanentLink(DocumentView docView) {
        this.restHelper.initContextFromRestRequest(docView);
        return "search";
    }

    @Observer(value={"localConfigurationChanged"})
    public void invalidateContentViewsName() {
        this.clearSearch();
        this.contentViewHeaders = null;
        this.currentContentViewName = null;
    }

    @Observer(value={"userAllDocumentTypesSelectionChanged"})
    public void invalidateContentViewsNameIfChanged() {
        ArrayList<ContentViewHeader> temp = new ArrayList<ContentViewHeader>(((SearchUIService)Framework.getService(SearchUIService.class)).getContentViewHeaders(this.actionContextProvider.createActionContext(), this.navigationContext.getCurrentDocument()));
        if (temp != null) {
            String s;
            if (!temp.equals(this.contentViewHeaders)) {
                this.invalidateContentViewsName();
            }
            if (!temp.isEmpty() && (s = ((ContentViewHeader)temp.get(0)).getName()) != null && !s.equals(this.currentContentViewName)) {
                this.invalidateContentViewsName();
            }
        }
    }

    @Observer(value={"flush"}, create=false)
    @BypassInterceptors
    public void resetOnFlush() {
        this.contentViewHeaders = null;
        this.currentSelectedSavedSearchId = null;
        this.currentContentViewName = null;
        this.nxqlQuery = DEFAULT_NXQL_QUERY;
        this.simpleSearchKeywords = "";
    }

    public String getSearchTermParameter() {
        return SEARCH_TERM_PARAMETER;
    }

    @Observer(value={"searchSaved"})
    public void onSearchSaved() {
        this.contentViewActions.refreshOnSeamEvent(SEARCH_SAVED_EVENT);
        this.contentViewActions.resetPageProviderOnSeamEvent(SEARCH_SAVED_EVENT);
    }
}

