/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.web.admin;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.web.admin.PageProviderStatus;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;

@Name(value="esAdmin")
@Scope(value=ScopeType.CONVERSATION)
public class ElasticSearchManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ElasticSearchManager.class);
    private static final String DEFAULT_NXQL_QUERY = "SELECT * FROM Document";
    private static final String JSON_DELETE_CMD = "{\"id\":\"IndexingCommand-reindex\",\"type\":\"DELETE\",\"docId\":\"%s\",\"repo\":\"%s\",\"recurse\":true,\"sync\":true}";
    private static final String ES_CLUSTER_INFO_PROPERTY = "elasticsearch.adminCenter.displayClusterInfo";
    @In(create=true)
    protected ElasticSearchAdmin esa;
    @In(create=true)
    protected ElasticSearchIndexing esi;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    protected List<PageProviderStatus> ppStatuses = null;
    protected Timer indexTimer;
    protected Timer bulkIndexTimer;
    private String rootId;
    private String nxql = "SELECT * FROM Document";
    private List<String> repositoryNames;
    private String repositoryName;
    private Boolean dropIndex = false;

    public String getNodesInfo() {
        return this.esa.getClient().getNodesInfo();
    }

    public String getNodesStats() {
        return this.esa.getClient().getNodesStats();
    }

    public String getNodesHealth() {
        String[] indices = this.getIndexNames();
        return this.esa.getClient().getHealthStatus(indices).toString();
    }

    public void startReindexAll() {
        String repositoryName = this.getRepositoryName();
        log.warn((Object)("Re-indexing the entire repository: " + repositoryName));
        this.esi.reindexRepository(repositoryName);
    }

    public void startReindexNxql() {
        String repositoryName = this.getRepositoryName();
        log.warn((Object)String.format("Re-indexing from a NXQL query: %s on repository: %s", this.getNxql(), repositoryName));
        this.esi.runReindexingWorker(repositoryName, this.getNxql());
    }

    public void startReindexFrom() {
        String repositoryName = this.getRepositoryName();
        try (CoreSession session = CoreInstance.openCoreSessionSystem((String)repositoryName);){
            log.warn((Object)String.format("Try to remove %s and its children from %s repository index", this.rootId, repositoryName));
            String jsonCmd = String.format(JSON_DELETE_CMD, this.rootId, repositoryName);
            IndexingCommand rmCmd = IndexingCommand.fromJSON((String)jsonCmd);
            this.esi.indexNonRecursive(rmCmd);
            IdRef ref = new IdRef(this.rootId);
            if (session.exists((DocumentRef)ref)) {
                DocumentModel doc = session.getDocument((DocumentRef)ref);
                log.warn((Object)String.format("Re-indexing document: %s and its children on repository: %s", doc, repositoryName));
                IndexingCommand cmd = new IndexingCommand(doc, IndexingCommand.Type.INSERT, false, true);
                this.esi.runIndexingWorker(Arrays.asList(cmd));
            }
        }
    }

    public void flush() {
        this.esa.flush();
    }

    public void optimize() {
        this.esa.optimize();
    }

    protected void introspectPageProviders() {
        this.ppStatuses = new ArrayList<PageProviderStatus>();
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        for (String ppName : pps.getPageProviderDefinitionNames()) {
            PageProviderDefinition def = pps.getPageProviderDefinition(ppName);
            PageProvider pp = pps.getPageProvider(ppName, def, null, null, Long.valueOf(0L), Long.valueOf(0L), null, new Object[0]);
            String klass = pp.getClass().getCanonicalName();
            this.ppStatuses.add(new PageProviderStatus(ppName, klass));
        }
        Collections.sort(this.ppStatuses);
    }

    public List<PageProviderStatus> getContentViewStatus() {
        if (this.ppStatuses == null) {
            this.introspectPageProviders();
        }
        return this.ppStatuses;
    }

    public Boolean isIndexingInProgress() {
        return this.esa.isIndexingInProgress();
    }

    public Boolean displayClusterInfo() {
        if (this.esa.isEmbedded()) {
            return true;
        }
        return Boolean.parseBoolean(Framework.getProperty((String)ES_CLUSTER_INFO_PROPERTY, (String)"false"));
    }

    public String getPendingWorkerCount() {
        return Long.valueOf(this.esa.getPendingWorkerCount()).toString();
    }

    public String getRunningWorkerCount() {
        return Long.valueOf(this.esa.getRunningWorkerCount()).toString();
    }

    public String getTotalCommandProcessed() {
        return Integer.valueOf(this.esa.getTotalCommandProcessed()).toString();
    }

    public String getNumberOfDocuments() {
        String[] indices = this.getIndexNames();
        SearchResponse ret = this.esa.getClient().search(new SearchRequest(indices).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).size(0)));
        return Long.valueOf(ret.getHits().totalHits).toString();
    }

    private String[] getIndexNames() {
        List<String> repositoryNames = this.getRepositoryNames();
        String[] indices = new String[repositoryNames.size()];
        int i = 0;
        for (String repo : repositoryNames) {
            indices[i++] = this.esa.getIndexNameForRepository(repo);
        }
        return indices;
    }

    public String getIndexingRates() {
        if (this.indexTimer == null) {
            MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
            this.indexTimer = registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "index"}));
        }
        return String.format("%.2f, %.2f, %.2f", this.indexTimer.getOneMinuteRate(), this.indexTimer.getFiveMinuteRate(), this.indexTimer.getFifteenMinuteRate());
    }

    public String getBulkIndexingRates() {
        if (this.bulkIndexTimer == null) {
            MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
            this.bulkIndexTimer = registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "bulkIndex"}));
        }
        return String.format("%.2f, %.2f, %.2f", this.bulkIndexTimer.getOneMinuteRate(), this.bulkIndexTimer.getFiveMinuteRate(), this.bulkIndexTimer.getFifteenMinuteRate());
    }

    public String getRootId() {
        return this.rootId;
    }

    public List<String> getRepositoryNames() {
        if (this.repositoryNames == null) {
            this.repositoryNames = this.esa.getRepositoryNames();
        }
        return this.repositoryNames;
    }

    public void setRootId(String rootId) {
        this.rootId = rootId;
    }

    public String getNxql() {
        return this.nxql;
    }

    public void setNxql(String nxql) {
        this.nxql = nxql;
    }

    public String getRepositoryName() {
        List<String> repositoryNames;
        if (this.repositoryName == null && !(repositoryNames = this.getRepositoryNames()).isEmpty()) {
            this.repositoryName = repositoryNames.get(0);
        }
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public Boolean getDropIndex() {
        return this.dropIndex;
    }

    public void setDropIndex(Boolean dropIndex) {
        this.dropIndex = dropIndex;
    }
}

