/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRow;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.WidgetTagHandler;
import org.nuxeo.ecm.platform.ui.web.binding.BlockingVariableMapper;

public class LayoutRowWidgetTagHandler
extends TagHandler {
    private static final Log log = LogFactory.getLog(LayoutRowWidgetTagHandler.class);
    protected final TagConfig config;
    protected final TagAttribute recomputeIds;

    public LayoutRowWidgetTagHandler(TagConfig config) {
        super(config);
        this.config = config;
        this.recomputeIds = this.getAttribute("recomputeIds");
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (FaceletHandlerHelper.isAliasOptimEnabled()) {
            this.applyOptimized(ctx, parent);
        } else {
            this.applyCompat(ctx, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyOptimized(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        LayoutRow row = null;
        FaceletHandlerHelper helper = new FaceletHandlerHelper(this.config);
        String rowVariableName = this.getInstanceName();
        TagAttribute rowAttribute = helper.createAttribute(rowVariableName, "#{" + rowVariableName + "}");
        if (rowAttribute != null) {
            row = (LayoutRow)rowAttribute.getObject(ctx, LayoutRow.class);
        }
        if (row == null) {
            log.error((Object)("Could not resolve layout row " + rowAttribute));
            return;
        }
        Widget[] widgets = row.getWidgets();
        if (widgets == null || widgets.length == 0) {
            return;
        }
        boolean recomputeIdsBool = false;
        if (this.recomputeIds != null) {
            recomputeIdsBool = this.recomputeIds.getBoolean(ctx);
        }
        VariableMapper orig = ctx.getVariableMapper();
        try {
            int widgetCounter = 0;
            for (Widget widget : widgets) {
                BlockingVariableMapper vm = new BlockingVariableMapper(orig);
                ctx.setVariableMapper((VariableMapper)vm);
                if (widget != null && (widget.getId() == null || recomputeIdsBool)) {
                    WidgetTagHandler.generateWidgetId(ctx, helper, widget, false);
                }
                WidgetTagHandler.exposeWidgetVariables(ctx, vm, widget, widgetCounter, true);
                this.nextHandler.apply(ctx, parent);
                ++widgetCounter;
            }
        }
        finally {
            ctx.setVariableMapper(orig);
        }
    }

    protected String getInstanceName() {
        return RenderVariables.rowVariables.layoutRow.name();
    }

    protected void applyCompat(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        LayoutRow row = null;
        FaceletHandlerHelper helper = new FaceletHandlerHelper(this.config);
        String rowVariableName = RenderVariables.rowVariables.layoutRow.name();
        TagAttribute rowAttribute = helper.createAttribute(rowVariableName, "#{" + rowVariableName + "}");
        if (rowAttribute != null) {
            row = (LayoutRow)rowAttribute.getObject(ctx, LayoutRow.class);
        }
        if (row == null) {
            log.error((Object)("Could not resolve layout row " + rowAttribute));
            return;
        }
        Widget[] widgets = row.getWidgets();
        if (widgets == null || widgets.length == 0) {
            return;
        }
        boolean recomputeIdsBool = false;
        if (this.recomputeIds != null) {
            recomputeIdsBool = this.recomputeIds.getBoolean(ctx);
        }
        int widgetCounter = 0;
        for (Widget widget : widgets) {
            if (widget != null && (widget.getId() == null || recomputeIdsBool)) {
                WidgetTagHandler.generateWidgetId(ctx, helper, widget, false);
            }
            HashMap<String, ValueExpression> variables = new HashMap<String, ValueExpression>();
            ExpressionFactory eFactory = ctx.getExpressionFactory();
            ValueExpression widgetVe = eFactory.createValueExpression((Object)widget, Widget.class);
            variables.put(RenderVariables.widgetVariables.widget.name(), widgetVe);
            Integer level = null;
            String tagConfigId = null;
            if (widget != null) {
                level = widget.getLevel();
                tagConfigId = widget.getTagConfigId();
            }
            variables.put(RenderVariables.widgetVariables.widget.name() + "_" + level, widgetVe);
            ValueExpression widgetIndexVe = eFactory.createValueExpression((Object)widgetCounter, Integer.class);
            variables.put(RenderVariables.widgetVariables.widgetIndex.name(), widgetIndexVe);
            variables.put(RenderVariables.widgetVariables.widgetIndex.name() + "_" + level, widgetIndexVe);
            if (widget != null) {
                for (Map.Entry ctrl : widget.getControls().entrySet()) {
                    String key = (String)ctrl.getKey();
                    String name = RenderVariables.widgetVariables.widgetControl.name() + "_" + key;
                    Serializable value = (Serializable)ctrl.getValue();
                    variables.put(name, eFactory.createValueExpression((Object)value, Object.class));
                }
            }
            ArrayList<String> blockedPatterns = new ArrayList<String>();
            blockedPatterns.add(RenderVariables.widgetVariables.widget.name() + "*");
            blockedPatterns.add(RenderVariables.widgetVariables.widgetIndex.name() + "*");
            blockedPatterns.add(RenderVariables.widgetVariables.widgetControl.name() + "_*");
            FaceletHandler handler = helper.getAliasFaceletHandler(tagConfigId, variables, blockedPatterns, this.nextHandler);
            handler.apply(ctx, parent);
            ++widgetCounter;
        }
    }
}

