/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.holder;

import com.sun.faces.facelets.tag.jsf.ComponentSupport;
import java.io.IOException;
import java.util.List;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputText;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasEvent;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasVariableMapper;
import org.nuxeo.ecm.platform.ui.web.component.ResettableComponent;
import org.nuxeo.ecm.platform.ui.web.component.holder.NuxeoValueHolderBean;

public class UIValueHolder
extends HtmlInputText
implements ResettableComponent {
    private static final Log log = LogFactory.getLog(UIValueHolder.class);
    public static final String COMPONENT_TYPE = UIValueHolder.class.getName();
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    protected String var;
    protected transient Object submittedValue = null;
    protected Boolean submitValue;

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getRendererType() {
        return COMPONENT_TYPE;
    }

    public boolean getRendersChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(FacesEvent event) {
        if (event instanceof AliasEvent) {
            FacesContext context = this.getFacesContext();
            AliasVariableMapper alias = this.getAliasVariableMapper(context);
            try {
                AliasVariableMapper.exposeAliasesToRequest(context, alias);
                FacesEvent origEvent = ((AliasEvent)event).getOriginalEvent();
                origEvent.getComponent().broadcast(origEvent);
            }
            finally {
                if (alias != null) {
                    AliasVariableMapper.removeAliasesExposedToRequest(context, alias.getId());
                }
            }
        } else {
            super.broadcast(event);
        }
    }

    public void queueEvent(FacesEvent event) {
        event = new AliasEvent((UIComponent)this, event);
        super.queueEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        AliasVariableMapper alias = this.getAliasVariableMapper(context);
        try {
            AliasVariableMapper.exposeAliasesToRequest(context, alias);
            boolean bl = super.invokeOnComponent(context, clientId, callback);
            return bl;
        }
        finally {
            if (alias != null) {
                AliasVariableMapper.removeAliasesExposedToRequest(context, alias.getId());
            }
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        AliasVariableMapper alias = this.getAliasVariableMapper(context);
        AliasVariableMapper.exposeAliasesToRequest(context, alias);
        super.encodeBegin(context);
    }

    public void encodeChildren(FacesContext context) throws IOException {
        this.processFacetsAndChildren(context, PhaseId.RENDER_RESPONSE);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        AliasVariableMapper alias = this.getAliasVariableMapper(context);
        if (alias != null) {
            AliasVariableMapper.removeAliasesExposedToRequest(context, alias.getId());
        }
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        this.processFacetsAndChildrenWithVariable(context, PhaseId.APPLY_REQUEST_VALUES);
        if (this.isImmediate()) {
            this.executeValidate(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.processFacetsAndChildrenWithVariable(context, PhaseId.PROCESS_VALIDATIONS);
        if (!this.isImmediate()) {
            this.executeValidate(context);
        }
    }

    private void executeValidate(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.processFacetsAndChildrenWithVariable(context, PhaseId.UPDATE_MODEL_VALUES);
        if (Boolean.TRUE.equals(this.getSubmitValue())) {
            try {
                this.updateModel(context);
            }
            catch (RuntimeException e) {
                context.renderResponse();
                throw e;
            }
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    protected final void processFacetsAndChildren(FacesContext context, PhaseId phaseId) {
        List stamps = this.getChildren();
        for (UIComponent stamp : stamps) {
            this.processComponent(context, stamp, phaseId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void processFacetsAndChildrenWithVariable(FacesContext context, PhaseId phaseId) {
        AliasVariableMapper alias = this.getAliasVariableMapper(context);
        try {
            AliasVariableMapper.exposeAliasesToRequest(context, alias);
            this.processFacetsAndChildren(context, phaseId);
        }
        finally {
            if (alias != null) {
                AliasVariableMapper.removeAliasesExposedToRequest(context, alias.getId());
            }
        }
    }

    protected final void processComponent(FacesContext context, UIComponent component, PhaseId phaseId) {
        if (component != null) {
            if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                component.processDecodes(context);
            } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                component.processValidators(context);
            } else if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                component.processUpdates(context);
            } else if (phaseId == PhaseId.RENDER_RESPONSE) {
                try {
                    ComponentSupport.encodeRecursive((FacesContext)context, (UIComponent)component);
                }
                catch (IOException err) {
                    log.error((Object)("Error while rendering component " + component));
                }
            } else {
                throw new IllegalArgumentException("Bad PhaseId:" + phaseId);
            }
        }
    }

    public String getVar() {
        if (this.var != null) {
            return this.var;
        }
        ValueExpression ve = this.getValueExpression("var");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public Boolean getSubmitValue() {
        if (this.submitValue != null) {
            return this.submitValue;
        }
        ValueExpression ve = this.getValueExpression("submitValue");
        if (ve != null) {
            try {
                return Boolean.TRUE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return Boolean.TRUE;
    }

    public void setSubmitValue(Boolean submitValue) {
        this.submitValue = submitValue;
    }

    public Object getValueToExpose() {
        Object value = this.getSubmittedValue();
        if (value == null) {
            value = super.getValue();
        }
        return value;
    }

    protected AliasVariableMapper getAliasVariableMapper(FacesContext ctx) {
        String var = this.getVar();
        Object value = this.getValueToExpose();
        AliasVariableMapper alias = new AliasVariableMapper();
        String aliasId = this.getFaceletId();
        alias.setId(aliasId);
        alias.setVariable(var, ctx.getApplication().getExpressionFactory().createValueExpression(value, Object.class));
        return alias;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.var = (String)values[1];
        this.submitValue = (Boolean)values[2];
        this.submittedValue = values[3];
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.var, this.submitValue, this.getSubmittedValue()};
    }

    @Override
    public void resetCachedModel() {
        if (this.getValueExpression("value") != null) {
            this.setValue(null);
            this.setLocalValueSet(false);
        }
        this.setSubmittedValue(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext visitContext, VisitCallback callback) {
        if (!this.isVisitable(visitContext)) {
            return false;
        }
        FacesContext facesContext = visitContext.getFacesContext();
        AliasVariableMapper alias = this.getAliasVariableMapper(facesContext);
        try {
            AliasVariableMapper.exposeAliasesToRequest(facesContext, alias);
            boolean bl = super.visitTree(visitContext, callback);
            return bl;
        }
        finally {
            if (alias != null) {
                AliasVariableMapper.removeAliasesExposedToRequest(facesContext, alias.getId());
            }
        }
    }

    public String getFaceletId() {
        return (String)this.getAttributes().get("com.sun.faces.facelets.MARK_ID");
    }

    public NuxeoValueHolderBean lookupBean(FacesContext ctx) {
        String expr = "#{nuxeoValueHolderBean}";
        NuxeoValueHolderBean bean = (NuxeoValueHolderBean)ctx.getApplication().evaluateExpressionGet(ctx, expr, Object.class);
        if (bean == null) {
            log.error((Object)("Managed bean not found: " + expr));
            return null;
        }
        return bean;
    }

    protected void saveToBean(Object value) {
        NuxeoValueHolderBean bean;
        if (this.getFaceletId() == null) {
            return;
        }
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx != null && (bean = this.lookupBean(ctx)) != null) {
            bean.saveState(this, value);
        }
    }

    public void setSubmittedValue(Object submittedValue) {
        this.submittedValue = submittedValue;
        this.saveToBean(submittedValue);
    }

    public Object getSubmittedValue() {
        return this.submittedValue;
    }

    public void setValue(Object value) {
        super.setValue(value);
        this.saveToBean(value);
    }
}

