/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.platform.publisher.api.PublisherService;
import org.nuxeo.ecm.platform.publisher.helper.RootSectionFinder;
import org.nuxeo.ecm.platform.publisher.helper.RootSectionsManager;
import org.nuxeo.ecm.platform.publisher.web.AbstractPublishActions;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNode;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNodeImpl;
import org.nuxeo.ecm.webapp.tree.TreeManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="adminPublishActions")
@Scope(value=ScopeType.CONVERSATION)
public class AdministrationPublishActions
extends AbstractPublishActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AdministrationPublishActions.class);
    public static final String PUBLICATION_TREE_PLUGIN_NAME = "publication";
    protected transient RootSectionFinder rootFinder;
    protected transient RootSectionsManager rootSectionsManager;
    protected transient TreeManager treeManager;
    protected DocumentTreeNode sectionsTree;
    protected DocumentModelList sectionRoots;
    protected String currentSectionRootId;

    @Create
    public void create() {
        this.rootSectionsManager = new RootSectionsManager(this.documentManager);
    }

    @Factory(value="defaultPublishingRoots", scope=ScopeType.EVENT)
    public DocumentModelList getSectionRoots() {
        return this.getRootFinder().getDefaultSectionRoots(true, true);
    }

    protected RootSectionFinder getRootFinder() {
        if (this.rootFinder == null) {
            PublisherService ps = (PublisherService)Framework.getService(PublisherService.class);
            this.rootFinder = ps.getRootSectionFinder(this.documentManager);
        }
        return this.rootFinder;
    }

    public String getCurrentSectionRootId() {
        return this.currentSectionRootId;
    }

    public List<DocumentTreeNode> getCurrentSectionsTree() {
        DocumentModel sectionsRoot = null;
        this.sectionRoots = this.getSectionRoots();
        if (this.currentSectionRootId == null && this.sectionRoots.size() > 0) {
            this.currentSectionRootId = ((DocumentModel)this.sectionRoots.get(0)).getId();
        }
        if (this.currentSectionRootId != null) {
            sectionsRoot = this.documentManager.getDocument((DocumentRef)new IdRef(this.currentSectionRootId));
        }
        this.sectionsTree = this.getDocumentTreeNode(sectionsRoot);
        return Collections.singletonList(this.sectionsTree);
    }

    public void setCurrentSectionRootId(String currentSectionRootId) {
        this.currentSectionRootId = currentSectionRootId;
    }

    public String getDomainNameFor(final DocumentModel sectionRoot) {
        final ArrayList domainName = new ArrayList();
        new UnrestrictedSessionRunner(this.documentManager){

            public void run() {
                DocumentModel parent = this.session.getParentDocument(sectionRoot.getRef());
                SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
                while (parent != null && !"/".equals(parent.getPathAsString())) {
                    if (!schemaManager.hasSuperType(parent.getType(), "Domain")) continue;
                    domainName.add(parent.getTitle());
                    return;
                }
            }
        }.runUnrestricted();
        return domainName.isEmpty() ? null : (String)domainName.get(0);
    }

    protected DocumentTreeNode getDocumentTreeNode(DocumentModel documentModel) {
        DocumentTreeNodeImpl documentTreeNode = null;
        if (documentModel != null) {
            Filter filter = this.getTreeManager().getFilter(PUBLICATION_TREE_PLUGIN_NAME);
            Sorter sorter = this.getTreeManager().getSorter(PUBLICATION_TREE_PLUGIN_NAME);
            documentTreeNode = new DocumentTreeNodeImpl(documentModel, filter, sorter);
        }
        return documentTreeNode;
    }

    protected TreeManager getTreeManager() {
        if (this.treeManager == null) {
            this.treeManager = (TreeManager)Framework.getService(TreeManager.class);
        }
        return this.treeManager;
    }

    public boolean canAddSection(DocumentModel section) {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.rootSectionsManager.canAddSection(section, currentDocument);
    }

    public String addSection(String sectionId) {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        this.rootSectionsManager.addSection(sectionId, currentDocument);
        this.getRootFinder().reset();
        return null;
    }

    public DocumentModelList getSelectedSections() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.getRootFinder().getSectionRootsForWorkspace(currentDocument, true);
    }

    public String removeSection(String sectionId) {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        this.rootSectionsManager.removeSection(sectionId, currentDocument);
        this.getRootFinder().reset();
        return null;
    }

    protected static String formatPathFragments(List<String> pathFragments) {
        String fullPath = "";
        for (String aFragment : pathFragments) {
            if (!"".equals(fullPath)) {
                fullPath = ">" + fullPath;
            }
            fullPath = aFragment + fullPath;
        }
        return fullPath;
    }

    @Override
    protected DocumentModel getParentDocument(DocumentModel documentModel) {
        return this.documentManager.getDocument(documentModel.getParentRef());
    }
}

