/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.richfaces.context.IdParser;
import org.richfaces.context.RowsFunctionContextCallback;
import org.richfaces.util.SeparatorChar;

class ClientIdFunctionEvaluator {
    private FacesContext context;
    private UIComponent functionTarget;
    private IdParser.Node[] parsedId;
    private Collection<String> resolvedIds = Lists.newArrayListWithCapacity((int)1);

    public ClientIdFunctionEvaluator(FacesContext context, IdParser.Node[] parsedId) {
        this.context = context;
        this.parsedId = parsedId;
    }

    private void walk(UIComponent component, String baseId, int nodeIdx) {
        UIComponent childComponent;
        Collection<String> directSubtreeIds;
        boolean isLastNode = nodeIdx == this.parsedId.length - 1;
        IdParser.Node node = this.parsedId[nodeIdx];
        if (node.getFunction() == null) {
            directSubtreeIds = Collections.singleton(node.getImage());
            childComponent = component;
        } else {
            directSubtreeIds = this.evaluateFunction(component, baseId, node);
            childComponent = this.functionTarget;
        }
        for (String directSubtreeId : directSubtreeIds) {
            String clientId = SeparatorChar.JOINER.join(baseId, directSubtreeId);
            if (isLastNode) {
                this.resolvedIds.add(clientId);
                continue;
            }
            this.walk(childComponent, clientId, nodeIdx + 1);
        }
    }

    private Collection<String> evaluateFunction(UIComponent component, String baseId, IdParser.Node node) {
        String function = node.getFunction();
        String image = node.getImage();
        if (!"rows".equals(function)) {
            throw new IllegalArgumentException(MessageFormat.format("Function {0} is not supported", function));
        }
        RowsFunctionContextCallback rowsFunctionCallback = new RowsFunctionContextCallback(image);
        if (!component.invokeOnComponent(this.context, baseId, (ContextCallback)rowsFunctionCallback)) {
            throw new IllegalStateException(MessageFormat.format("Failed to visit {0}", baseId));
        }
        this.functionTarget = rowsFunctionCallback.getComponent();
        Collection<String> directSubtreeIds = rowsFunctionCallback.getConvertedKeys();
        return directSubtreeIds;
    }

    public Collection<String> evaluate(UIComponent component) {
        this.walk(component, null, 0);
        return this.resolvedIds;
    }
}

