/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cache;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.application.configuration.ConfigurationServiceHelper;
import org.richfaces.cache.Cache;
import org.richfaces.cache.CacheFactory;
import org.richfaces.cache.EhCacheCache;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public class EhCacheCacheFactory
implements CacheFactory {
    private static final Logger LOG = RichfacesLogger.CACHE.getLogger();
    private CacheManager cacheManager;

    public EhCacheCacheFactory() {
        URL configUrl = null;
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        if (ccl != null) {
            configUrl = ccl.getResource("ehcache.xml");
        }
        if (configUrl != null) {
            LOG.info(MessageFormat.format("Using cache configuration: {0}", configUrl.toExternalForm()));
        } else {
            configUrl = EhCacheCacheFactory.class.getResource("ehcache-failsafe-richfaces.xml");
            LOG.info(MessageFormat.format("Using default cache configuration: {0}", configUrl.toExternalForm()));
        }
        this.cacheManager = CacheManager.create((URL)configUrl);
    }

    @Override
    public Cache createCache(FacesContext facesContext, String cacheName, Map<?, ?> env) {
        LOG.info("Creating EhCache cache instance");
        int maxCacheSize = ConfigurationServiceHelper.getIntConfigurationValue(facesContext, CoreConfiguration.Items.resourcesCacheSize);
        boolean preconfiguredCache = false;
        Ehcache ehcache = this.cacheManager.getEhcache(cacheName);
        if (ehcache == null) {
            ehcache = new net.sf.ehcache.Cache(cacheName, maxCacheSize, false, true, 0L, 0L);
        } else {
            preconfiguredCache = true;
            if (ehcache.getCacheConfiguration().getMaxElementsInMemory() <= 0) {
                LOG.info(MessageFormat.format("Maximum cache size hasn''t been set, resetting to {0} max items", maxCacheSize));
                ehcache.getCacheConfiguration().setMaxElementsInMemory(maxCacheSize);
            }
        }
        return new EhCacheCache(ehcache, preconfiguredCache);
    }

    @Override
    public void destroy() {
        this.cacheManager.shutdown();
        this.cacheManager = null;
    }
}

