/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.io;

import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.io.XMLResponseWriterState;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SAXResponseWriter
extends ResponseWriter {
    private static final String CHARTER_ENCODING = "UTF-8";
    private static final String CONTENT_TYPE = "text/xml";
    private String namespaceURI = "http://www.w3.org/1999/xhtml";
    private LexicalHandler xmlLexicalHandler = null;
    private AttributesImpl attributes;
    private XMLResponseWriterState cdataState;
    private String element;
    private XMLResponseWriterState elementState;
    private XMLResponseWriterState inDocumentState;
    private XMLResponseWriterState notDocumentState;
    private XMLResponseWriterState state;
    private ContentHandler xmlConsumer;

    public SAXResponseWriter(ContentHandler consumer) {
        this.xmlConsumer = consumer;
        if (consumer instanceof LexicalHandler) {
            this.xmlLexicalHandler = (LexicalHandler)((Object)consumer);
        }
        this.notDocumentState = new NotDocumentState();
        this.inDocumentState = new InDocumentState();
        this.cdataState = new CDATAState();
        this.elementState = new ElementState();
        this.state = this.notDocumentState;
    }

    public ContentHandler getXmlConsumer() {
        return this.xmlConsumer;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public String getCharacterEncoding() {
        return CHARTER_ENCODING;
    }

    public void flush() throws IOException {
    }

    public void startDocument() throws IOException {
        this.state.startDocument();
    }

    public void endDocument() throws IOException {
        this.state.endDocument();
    }

    public void startElement(String name, UIComponent component) throws IOException {
        this.state.startElement(name, component);
    }

    public void endElement(String name) throws IOException {
        this.state.endElement(name);
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        this.state.writeAttribute(name, value, property);
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        this.state.writeURIAttribute(name, value, property);
    }

    public void writeComment(Object comment) throws IOException {
        this.state.writeComment(comment);
    }

    public void writeText(Object text, String property) throws IOException {
        this.state.writeText(text, property);
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        this.state.writeText(text, off, len);
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return this;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.state.writeText(cbuf, off, len);
    }

    public void close() throws IOException {
    }

    private final class NotDocumentState
    extends XMLResponseWriterState {
        private NotDocumentState() {
        }

        @Override
        void startDocument() throws IOException {
            try {
                SAXResponseWriter.this.xmlConsumer.startDocument();
            }
            catch (SAXException e) {
                throw new IOException("StartDocument SAX exception :" + e.getMessage());
            }
            finally {
                SAXResponseWriter.this.state = SAXResponseWriter.this.inDocumentState;
            }
        }
    }

    private final class InDocumentState
    extends XMLResponseWriterState {
        private InDocumentState() {
        }

        @Override
        void startElement(String name, UIComponent component) {
            SAXResponseWriter.this.element = name;
            SAXResponseWriter.this.attributes = new AttributesImpl();
            SAXResponseWriter.this.state = SAXResponseWriter.this.elementState;
        }

        @Override
        void writeComment(Object comment) throws IOException {
            String remark = comment.toString();
            try {
                SAXResponseWriter.this.xmlLexicalHandler.comment(remark.toCharArray(), 0, remark.length());
            }
            catch (SAXException e) {
                throw new IOException("Comment SAX exception :" + e.getMessage());
            }
        }

        @Override
        void writeText(Object o, String property) throws IOException {
            this.writeText(o.toString().toCharArray(), 0, o.toString().length());
        }

        @Override
        void writeText(char[] text, int start, int lenght) throws IOException {
            SAXResponseWriter.this.state = SAXResponseWriter.this.cdataState;
            SAXResponseWriter.this.state.writeText(text, start, lenght);
        }

        @Override
        void endElement(String name) throws IOException {
            try {
                SAXResponseWriter.this.xmlConsumer.endElement(SAXResponseWriter.this.getNamespaceURI(), name, name);
            }
            catch (SAXException e) {
                throw new IOException("Sax exceptions in endElement: " + e.getMessage());
            }
        }

        @Override
        void endDocument() throws IOException {
            try {
                SAXResponseWriter.this.xmlConsumer.endDocument();
            }
            catch (SAXException e) {
                throw new IOException("Sax exceptions in endDocument" + e.getMessage());
            }
            finally {
                SAXResponseWriter.this.state = new XMLResponseWriterState();
            }
        }
    }

    private final class ElementState
    extends XMLResponseWriterState {
        private ElementState() {
        }

        void flushElement() throws IOException {
            try {
                SAXResponseWriter.this.xmlConsumer.startElement(SAXResponseWriter.this.getNamespaceURI(), SAXResponseWriter.this.element, SAXResponseWriter.this.element, SAXResponseWriter.this.attributes);
            }
            catch (SAXException e) {
                throw new IOException("Exception in startElement: " + e.getMessage());
            }
            finally {
                SAXResponseWriter.this.element = null;
                SAXResponseWriter.this.attributes = null;
            }
        }

        @Override
        void writeAttribute(String name, Object value, String property) throws IOException {
            SAXResponseWriter.this.attributes.addAttribute(SAXResponseWriter.this.getNamespaceURI(), name, name, "id".equalsIgnoreCase(name) ? "ID" : "CDATA", value.toString());
        }

        @Override
        void writeURIAttribute(String name, Object value, String property) throws IOException {
            String uri = value.toString();
            SAXResponseWriter.this.attributes.addAttribute(SAXResponseWriter.this.getNamespaceURI(), name, name, "CDATA", uri);
        }

        @Override
        void endElement(String name) throws IOException {
            this.flushElement();
            SAXResponseWriter.this.state = SAXResponseWriter.this.inDocumentState;
            SAXResponseWriter.this.state.endElement(name);
        }

        @Override
        void startElement(String name, UIComponent component) throws IOException {
            this.flushElement();
            SAXResponseWriter.this.element = name;
            SAXResponseWriter.this.attributes = new AttributesImpl();
        }

        @Override
        void writeComment(Object comment) throws IOException {
            this.flushElement();
            SAXResponseWriter.this.state = SAXResponseWriter.this.inDocumentState;
            SAXResponseWriter.this.state.writeComment(comment);
        }

        @Override
        void writeText(char[] text, int off, int len) throws IOException {
            this.flushElement();
            SAXResponseWriter.this.state = SAXResponseWriter.this.cdataState;
            SAXResponseWriter.this.state.writeText(text, off, len);
        }

        @Override
        void writeText(Object text, String property) throws IOException {
            this.flushElement();
            SAXResponseWriter.this.state = SAXResponseWriter.this.cdataState;
            SAXResponseWriter.this.state.writeText(text, property);
        }
    }

    private final class CDATAState
    extends XMLResponseWriterState {
        private CDATAState() {
        }

        void flushCDATA() throws IOException {
        }

        @Override
        void endDocument() throws IOException {
            this.flushCDATA();
            SAXResponseWriter.this.state = SAXResponseWriter.this.inDocumentState;
            SAXResponseWriter.this.state.endDocument();
        }

        @Override
        void endElement(String name) throws IOException {
            this.flushCDATA();
            SAXResponseWriter.this.state = SAXResponseWriter.this.inDocumentState;
            SAXResponseWriter.this.state.endElement(name);
        }

        @Override
        void startElement(String name, UIComponent component) throws IOException {
            this.flushCDATA();
            SAXResponseWriter.this.element = name;
            SAXResponseWriter.this.attributes = new AttributesImpl();
            SAXResponseWriter.this.state = SAXResponseWriter.this.elementState;
        }

        @Override
        void writeComment(Object comment) throws IOException {
            this.flushCDATA();
            SAXResponseWriter.this.state = SAXResponseWriter.this.inDocumentState;
            SAXResponseWriter.this.state.writeComment(comment);
        }

        @Override
        void writeText(char[] text, int off, int len) throws IOException {
            try {
                SAXResponseWriter.this.xmlConsumer.characters(text, off, len);
            }
            catch (SAXException e) {
                throw new IOException("Sax exceptions in writeText: " + e.getMessage());
            }
        }

        @Override
        void writeText(Object text, String property) throws IOException {
            this.writeText(text.toString().toCharArray(), 0, text.toString().length());
        }

        @Override
        void write(char[] cbuf, int off, int len) throws IOException {
            this.writeText(cbuf, off, len);
        }
    }
}

