/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.action;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.trash.TrashInfo;
import org.nuxeo.ecm.core.trash.TrashService;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.webapp.action.DeleteActions;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.edit.lock.LockActions;
import org.nuxeo.ecm.webapp.trashManagement.TrashManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="deleteActions")
@Scope(value=ScopeType.EVENT)
@Install(precedence=10)
public class DeleteActionsBean
implements DeleteActions,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DeleteActionsBean.class);
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected RepositoryLocation currentServerLocation;
    @In(create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true)
    protected transient TrashManager trashManager;
    @In(create=true)
    protected transient LockActions lockActions;
    @In(create=true)
    protected transient WebActions webActions;
    @In
    protected transient Principal currentUser;
    protected transient TrashService trashService;
    protected static final int OP_DELETE = 1;
    protected static final int OP_PURGE = 2;
    protected static final int OP_UNDELETE = 3;

    protected TrashService getTrashService() {
        if (this.trashService == null) {
            this.trashService = (TrashService)Framework.getService(TrashService.class);
        }
        return this.trashService;
    }

    @Override
    public boolean getCanDeleteItem(DocumentModel container) {
        if (container == null) {
            return false;
        }
        return this.getTrashService().folderAllowsDelete(container);
    }

    @Override
    public boolean getCanDelete() {
        return this.getCanDelete("CURRENT_SELECTION");
    }

    @Override
    public boolean getCanDelete(String listName) {
        List docs = this.documentsListsManager.getWorkingList(listName);
        return this.getTrashService().canDelete(docs, this.currentUser, false);
    }

    @Override
    public boolean getCanDeleteSections() {
        List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_SECTIONS");
        return this.getTrashService().canDelete(docs, this.currentUser, true);
    }

    @Override
    public boolean getCanPurge() {
        List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_TRASH");
        return this.getTrashService().canPurgeOrUndelete(docs, this.currentUser);
    }

    public boolean getCanEmptyTrash() {
        List selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_TRASH");
        if (selectedDocuments.size() == 0) {
            DocumentModelList currentTrashDocuments = this.trashService.getDocuments(this.navigationContext.getCurrentDocument());
            return this.getTrashService().canPurgeOrUndelete((List)currentTrashDocuments, this.currentUser);
        }
        return false;
    }

    @Override
    public boolean checkDeletePermOnParents(List<DocumentModel> docs) {
        return this.getTrashService().checkDeletePermOnParents(docs);
    }

    @Override
    public String deleteSelection() {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
            return this.deleteSelection(this.documentsListsManager.getWorkingList("CURRENT_SELECTION"));
        }
        log.debug((Object)"No documents selection in context to process delete on...");
        return null;
    }

    @Override
    public String deleteSelectionSections() {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION_SECTIONS")) {
            return this.deleteSelection(this.documentsListsManager.getWorkingList("CURRENT_SELECTION_SECTIONS"));
        }
        log.debug((Object)"No documents selection in context to process delete on...");
        return null;
    }

    @Override
    public String deleteSelection(List<DocumentModel> docs) {
        int op = this.isTrashManagementEnabled() ? 1 : 2;
        return this.actOnSelection(op, docs);
    }

    public String emptyTrash() {
        DocumentModelList currentTrashDocuments = this.trashService.getDocuments(this.navigationContext.getCurrentDocument());
        return this.purgeSelection((List<DocumentModel>)currentTrashDocuments);
    }

    @Override
    public String purgeSelection() {
        return this.purgeSelection("CURRENT_SELECTION_TRASH");
    }

    @Override
    public String purgeSelection(String listName) {
        if (!this.documentsListsManager.isWorkingListEmpty(listName)) {
            return this.purgeSelection(this.documentsListsManager.getWorkingList(listName));
        }
        log.debug((Object)"No documents selection in context to process delete on...");
        return null;
    }

    @Override
    public String purgeSelection(List<DocumentModel> docs) {
        return this.actOnSelection(2, docs);
    }

    @Override
    public String undeleteSelection() {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION_TRASH")) {
            return this.undeleteSelection(this.documentsListsManager.getWorkingList("CURRENT_SELECTION_TRASH"));
        }
        log.debug((Object)"No documents selection in context to process delete on...");
        return null;
    }

    @Override
    public String undeleteSelection(List<DocumentModel> docs) {
        return this.actOnSelection(3, docs);
    }

    protected String actOnSelection(int op, List<DocumentModel> docs) {
        String msgid;
        Set parentRefs;
        if (docs == null) {
            return null;
        }
        TrashInfo info = this.getTrashService().getTrashInfo(docs, this.currentUser, false, false);
        DocumentModel targetContext = this.getTrashService().getAboveDocument(this.navigationContext.getCurrentDocument(), info.rootPaths);
        this.documentsListsManager.removeFromAllLists(info.docs);
        switch (op) {
            case 2: {
                this.getTrashService().purgeDocuments(this.documentManager, info.rootRefs);
                parentRefs = info.rootParentRefs;
                msgid = "n_deleted_docs";
                break;
            }
            case 1: {
                this.getTrashService().trashDocuments(info.docs);
                parentRefs = info.rootParentRefs;
                msgid = "n_deleted_docs";
                break;
            }
            case 3: {
                parentRefs = this.getTrashService().undeleteDocuments(info.docs);
                msgid = "n_undeleted_docs";
                break;
            }
            default: {
                throw new AssertionError(op);
            }
        }
        if (op == 3) {
            targetContext = this.documentManager.getDocument((DocumentRef)new IdRef(targetContext.getId()));
        } else if (targetContext == null) {
            targetContext = this.documentManager.getRootDocument();
        }
        this.navigationContext.setCurrentDocument(targetContext);
        if (parentRefs.isEmpty()) {
            Events.instance().raiseEvent("documentChildrenChanged", new Object[0]);
        } else {
            for (DocumentRef parentRef : parentRefs) {
                DocumentModel parent;
                if (!this.documentManager.hasPermission(parentRef, "Read") || (parent = this.documentManager.getDocument(parentRef)) == null) continue;
                Events.instance().raiseEvent("documentChildrenChanged", new Object[]{parent});
            }
        }
        if (info.proxies > 0) {
            this.facesMessages.add(StatusMessage.Severity.WARN, "can_not_delete_proxies", new Object[0]);
        }
        Object[] params = new Object[]{info.docs.size()};
        this.facesMessages.add(StatusMessage.Severity.INFO, "#0 " + this.messages.get(msgid), params);
        return null;
    }

    @Override
    public boolean isTrashManagementEnabled() {
        return this.trashManager.isTrashManagementEnabled();
    }

    public List<Action> getActionsForTrashSelection() {
        return this.webActions.getActionsList("CURRENT_SELECTION_TRASH_LIST", Boolean.valueOf(false));
    }

    @Override
    public void create() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void restoreCurrentDocument() {
        ArrayList<DocumentModel> doc = new ArrayList<DocumentModel>();
        doc.add(this.navigationContext.getCurrentDocument());
        this.undeleteSelection(doc);
    }

    @Override
    public boolean getCanRestoreCurrentDoc() {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        if (doc == null) {
            log.warn((Object)"Null currentDocument in navigationContext");
            return false;
        }
        return this.getTrashService().canPurgeOrUndelete(Collections.singletonList(doc), this.currentUser);
    }

    public boolean restoreActionDisplay() {
        return this.getCanRestoreCurrentDoc() && this.isTrashManagementEnabled();
    }
}

