/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import javax.persistence.EntityManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.transaction.AbstractUserTransaction;

@Name(value="org.jboss.seam.transaction.transaction")
@Scope(value=ScopeType.EVENT)
@Install(value=false, precedence=10)
@BypassInterceptors
public class HibernateTransaction
extends AbstractUserTransaction {
    private static final LogProvider log = Logging.getLogProvider(HibernateTransaction.class);
    private Expressions.ValueExpression<Session> session;
    private Session currentSession;
    private boolean rollbackOnly;

    @Create
    public void validate() {
        if (this.session == null) {
            this.session = Expressions.instance().createValueExpression("#{session}", Session.class);
        }
    }

    private Transaction getDelegate() {
        if (this.currentSession == null) {
            throw new IllegalStateException("session is null");
        }
        return this.currentSession.getTransaction();
    }

    private void initSession() {
        this.currentSession = this.session.getValue();
        if (this.currentSession == null) {
            throw new IllegalStateException("session was null: " + this.session.getExpressionString());
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        log.debug("beginning Hibernate transaction");
        this.assertNotActive();
        this.initSession();
        try {
            this.getDelegate().begin();
        }
        catch (RuntimeException re) {
            this.clearSession();
            throw re;
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        log.debug("committing Hibernate transaction");
        this.assertActive();
        Transaction delegate = this.getDelegate();
        this.clearSession();
        if (this.rollbackOnly) {
            this.rollbackOnly = false;
            delegate.rollback();
            throw new RollbackException();
        }
        delegate.commit();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        log.debug("rolling back Hibernate transaction");
        this.assertActive();
        Transaction delegate = this.getDelegate();
        this.clearSession();
        this.rollbackOnly = false;
        delegate.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        log.debug("marking Hibernate transaction for rollback");
        this.assertActive();
        this.rollbackOnly = true;
    }

    public int getStatus() throws SystemException {
        if (this.rollbackOnly) {
            return 1;
        }
        if (this.isSessionSet() && this.getDelegate().isActive()) {
            return 0;
        }
        return 6;
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        this.assertActive();
        this.getDelegate().setTimeout(timeout);
    }

    private boolean isSessionSet() {
        return this.currentSession != null;
    }

    private void clearSession() {
        this.currentSession = null;
    }

    private void assertActive() {
        if (!this.isSessionSet()) {
            throw new IllegalStateException("transaction is not active");
        }
    }

    private void assertNotActive() throws NotSupportedException {
        if (this.isSessionSet()) {
            throw new NotSupportedException("transaction is already active");
        }
    }

    @Override
    public void registerSynchronization(Synchronization sync) {
        if (log.isDebugEnabled()) {
            log.debug("registering synchronization: " + sync);
        }
        this.assertActive();
        this.getDelegate().registerSynchronization(sync);
    }

    @Override
    public void enlist(EntityManager entityManager) throws SystemException {
        throw new UnsupportedOperationException("JPA EntityManager should not be used with Hibernate Transaction API");
    }

    @Override
    public boolean isConversationContextRequired() {
        return true;
    }

    public Expressions.ValueExpression<Session> getSession() {
        return this.session;
    }

    public void setSession(Expressions.ValueExpression<Session> entityManager) {
        this.session = entityManager;
    }
}

