/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.validation.ConstraintViolation;
import org.jboss.seam.Component;
import org.jboss.seam.Instance;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.ClassValidator;
import org.jboss.seam.el.EL;

@Name(value="org.jboss.seam.core.validators")
@BypassInterceptors
@Scope(value=ScopeType.APPLICATION)
@Install(precedence=0, classDependencies={"org.jboss.seam.core.ClassValidator"})
public class Validators {
    public <T> ClassValidator<T> getValidator(T model) {
        Class<?> modelClass = model instanceof Instance ? ((Instance)model).getComponent().getBeanClass() : model.getClass();
        return this.getValidator(modelClass);
    }

    public <T> ClassValidator<T> getValidator(Class<T> modelClass) {
        return this.createValidator(modelClass);
    }

    protected <T> ClassValidator<T> createValidator(Class<T> modelClass) {
        return new ClassValidator<T>(modelClass);
    }

    public Set<ConstraintViolation<Object>> validate(ValueExpression valueExpression, ELContext elContext, Object value) {
        ValidatingResolver validatingResolver = new ValidatingResolver(elContext.getELResolver());
        ELContext decoratedContext = EL.createELContext(elContext, validatingResolver);
        valueExpression.setValue(decoratedContext, value);
        return validatingResolver.getInvalidValues();
    }

    public static Validators instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application scope");
        }
        return (Validators)Component.getInstance(Validators.class, ScopeType.APPLICATION);
    }

    class ValidatingResolver
    extends ELResolver {
        private ELResolver delegate;
        private Set<ConstraintViolation<Object>> invalidValues;

        public ValidatingResolver(ELResolver delegate) {
            this.delegate = delegate;
        }

        public Set<ConstraintViolation<Object>> getInvalidValues() {
            return this.invalidValues;
        }

        public Class<?> getCommonPropertyType(ELContext context, Object value) {
            return this.delegate.getCommonPropertyType(context, value);
        }

        public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object value) {
            return this.delegate.getFeatureDescriptors(context, value);
        }

        public Class<?> getType(ELContext context, Object x, Object y) throws NullPointerException, PropertyNotFoundException, ELException {
            return this.delegate.getType(context, x, y);
        }

        public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
            return this.delegate.getValue(context, base, property);
        }

        public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
            return this.delegate.isReadOnly(context, base, property);
        }

        public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
            if (base != null && property != null) {
                context.setPropertyResolved(true);
                this.invalidValues = Validators.this.getValidator(base).getPotentialInvalidValues(property.toString(), value);
            }
        }
    }
}

