/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.lang.reflect.Method;
import org.jboss.seam.NoConversationException;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.Conversational;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.bpm.BeginTask;
import org.jboss.seam.annotations.bpm.StartTask;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.bpm.BusinessProcessInterceptor;
import org.jboss.seam.core.BijectionInterceptor;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Manager;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;

@Interceptor(stateless=true, around={BijectionInterceptor.class, BusinessProcessInterceptor.class})
public class ConversationalInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1127583515811479385L;

    @Override
    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        Method method = invocation.getMethod();
        if (this.isNoConversationForConversationalBean(method)) {
            Events.instance().raiseEvent("org.jboss.seam.noConversation", new Object[0]);
            throw new NoConversationException("no long-running conversation for @Conversational bean: " + this.getComponent().getName());
        }
        return invocation.proceed();
    }

    private boolean isNoConversationForConversationalBean(Method method) {
        boolean classlevelViolation;
        boolean bl = classlevelViolation = this.componentIsConversational() && !Manager.instance().isLongRunningOrNestedConversation() && !method.isAnnotationPresent(Begin.class) && !method.isAnnotationPresent(StartTask.class) && !method.isAnnotationPresent(BeginTask.class) && !method.isAnnotationPresent(Destroy.class) && !method.isAnnotationPresent(Create.class);
        if (classlevelViolation) {
            return true;
        }
        boolean methodlevelViolation = this.methodIsConversational(method) && !Manager.instance().isLongRunningOrNestedConversation();
        return methodlevelViolation;
    }

    private boolean methodIsConversational(Method method) {
        return method.isAnnotationPresent(Conversational.class);
    }

    private boolean componentIsConversational() {
        return this.getComponent().getBeanClass().isAnnotationPresent(Conversational.class);
    }

    @Override
    public boolean isInterceptorEnabled() {
        return this.getComponent().beanClassHasAnnotation(Conversational.class);
    }
}

