/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.ConversationEntries;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.web.Session;

@Scope(value=ScopeType.STATELESS)
@Name(value="org.jboss.seam.core.conversationListFactory")
@Install(precedence=0)
@BypassInterceptors
public class ConversationList {
    protected List<ConversationEntry> createConversationEntryList() {
        ConversationEntries conversationEntries = ConversationEntries.getInstance();
        if (conversationEntries == null) {
            return Collections.EMPTY_LIST;
        }
        TreeSet<ConversationEntry> orderedEntries = new TreeSet<ConversationEntry>();
        orderedEntries.addAll(conversationEntries.getConversationEntries());
        ArrayList<ConversationEntry> conversationEntryList = new ArrayList<ConversationEntry>(conversationEntries.size());
        for (ConversationEntry entry : orderedEntries) {
            if (!entry.isDisplayable() || Session.instance().isInvalid()) continue;
            conversationEntryList.add(entry);
        }
        return conversationEntryList;
    }

    @Factory(value="org.jboss.seam.core.conversationList", autoCreate=true, scope=ScopeType.PAGE)
    public List<ConversationEntry> getConversationEntryList() {
        return this.createConversationEntryList();
    }
}

