/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.graphicImage;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.servlet.ContextualHttpServletRequest;
import org.jboss.seam.ui.graphicImage.GraphicImageStore;
import org.jboss.seam.web.AbstractResource;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.ui.graphicImage.graphicImageResource")
@Install(precedence=0)
@BypassInterceptors
public class GraphicImageResource
extends AbstractResource {
    public static final String GRAPHIC_IMAGE_RESOURCE_PATH = "/seam/resource/graphicImage";
    private static final String RESOURCE_PATH = "/graphicImage";

    public String getResourcePath() {
        return RESOURCE_PATH;
    }

    public void getResource(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        new ContextualHttpServletRequest(request){

            public void process() throws IOException {
                GraphicImageResource.this.doWork(request, response);
            }
        }.run();
    }

    private void doWork(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathInfo = request.getPathInfo().substring(this.getResourcePath().length() + 1, request.getPathInfo().lastIndexOf("."));
        GraphicImageStore.ImageWrapper image = GraphicImageStore.instance().remove(pathInfo);
        if (image != null && image.getImage() != null) {
            response.setContentType(image.getContentType().getMimeType());
            response.setStatus(200);
            response.setContentLength(image.getImage().length);
            ServletOutputStream os = response.getOutputStream();
            os.write(image.getImage());
            os.flush();
        } else {
            response.sendError(404);
        }
    }
}

