/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.service.suggesters;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.platform.suggestbox.service.ComponentInitializationException;
import org.nuxeo.ecm.platform.suggestbox.service.SearchDocumentsSuggestion;
import org.nuxeo.ecm.platform.suggestbox.service.Suggester;
import org.nuxeo.ecm.platform.suggestbox.service.Suggestion;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionContext;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionException;
import org.nuxeo.ecm.platform.suggestbox.service.descriptors.SuggesterDescriptor;
import org.nuxeo.ecm.platform.suggestbox.service.suggesters.I18nHelper;
import org.nuxeo.ecm.platform.suggestbox.utils.DateMatcher;

@Deprecated
public class DocumentSearchByDateSuggester
implements Suggester {
    static final String type = "searchDocuments";
    static final String LABEL_BEFORE_PREFIX = "label.search.beforeDate_";
    static final String LABEL_AFTER_PREFIX = "label.search.afterDate_";
    protected String[] searchFields;
    protected String label;
    protected String iconURL;
    protected String suggesterId = "DocumentSearchByDateSuggester";

    @Override
    public List<Suggestion> suggest(String userInput, SuggestionContext context) throws SuggestionException {
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        I18nHelper i18n = I18nHelper.instanceFor(context.messages);
        DateMatcher matcher = DateMatcher.fromInput(userInput);
        DateFormat labelDateFormatter = DateFormat.getDateInstance(2, context.locale);
        if (matcher.hasMatch()) {
            Date date = matcher.getDateSuggestion().getTime();
            String formattedDateLabel = labelDateFormatter.format(date);
            for (String field : this.searchFields) {
                String searchFieldAfter = field + "_min";
                String labelAfterPrefix = LABEL_AFTER_PREFIX + field.replace(':', '_');
                String labelAfter = i18n.translate(labelAfterPrefix, formattedDateLabel);
                suggestions.add(new SearchDocumentsSuggestion(this.suggesterId, labelAfter, this.iconURL).withSearchCriterion(searchFieldAfter, date));
                String searchFieldBefore = field + "_max";
                String labelBeforePrefix = LABEL_BEFORE_PREFIX + field.replace(':', '_');
                String labelBefore = i18n.translate(labelBeforePrefix, formattedDateLabel);
                suggestions.add(new SearchDocumentsSuggestion(this.suggesterId, labelBefore, this.iconURL).withSearchCriterion(searchFieldBefore, date));
            }
        }
        return suggestions;
    }

    @Override
    public void initWithParameters(SuggesterDescriptor descriptor) throws ComponentInitializationException {
        Map<String, String> params = descriptor.getParameters();
        this.iconURL = params.get("iconURL");
        String searchFields = params.get("searchFields");
        if (searchFields == null || this.iconURL == null) {
            throw new ComponentInitializationException(String.format("Could not initialize suggester '%s': searchFields and iconURL are mandatory parameters", descriptor.getName()));
        }
        this.searchFields = searchFields.split(", *");
    }
}

