/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.documentsLists;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Base64;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;

public class DocumentsListsPersistenceManager {
    private static final String DIR_NAME = "documentsLists";
    private static final String ID_SEP = ":";
    private static final String DIR_COL_USERID = "userid";
    private static final String DIR_COL_LISTID = "listid";
    private static final String DIR_COL_REF = "ref";
    private static final String DIR_COL_REFTYPE = "reftype";
    private static final String DIR_COL_REPO = "repo";
    private static final boolean ENABLE_SANITY_CHECK = true;
    private static final boolean FIX_SANITY_ERROR = true;
    private static final Log log = LogFactory.getLog(DocumentsListsPersistenceManager.class);
    private DirectoryService directoryService;
    private Session dirSession;
    private String directorySchema;

    private static String getIdForEntry(String userName, String listName, DocumentModel doc) {
        String ref = doc.getRef().toString();
        int refType = doc.getRef().type();
        String repoId = doc.getRepositoryName();
        return DocumentsListsPersistenceManager.getIdForEntry(userName, listName, ref, refType, repoId);
    }

    private static String getIdForEntry(String userName, String listName, String ref, int refType, String repoId) {
        byte[] idDigest;
        StringBuilder sb = new StringBuilder();
        sb.append(listName);
        sb.append(ID_SEP);
        sb.append(userName);
        sb.append(ID_SEP);
        sb.append(refType);
        sb.append(ID_SEP);
        sb.append(ref);
        sb.append(ID_SEP);
        sb.append(repoId);
        try {
            idDigest = MessageDigest.getInstance("MD5").digest(sb.toString().getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            return sb.toString();
        }
        return Base64.encodeBytes((byte[])idDigest);
    }

    private boolean initPersistentService() {
        if (this.dirSession != null) {
            return true;
        }
        if (this.directoryService == null) {
            this.directoryService = DirectoryHelper.getDirectoryService();
            if (this.directoryService == null) {
                return false;
            }
        }
        try {
            this.dirSession = this.directoryService.open(DIR_NAME);
            this.directorySchema = this.directoryService.getDirectorySchema(DIR_NAME);
        }
        catch (DirectoryException e) {
            this.dirSession = null;
            log.error((Object)("Unable to open directory documentsLists : " + e.getMessage()));
            return false;
        }
        return true;
    }

    private void releasePersistenceService() {
        if (this.directoryService == null) {
            this.dirSession = null;
            return;
        }
        if (this.dirSession != null) {
            try {
                this.dirSession.close();
            }
            catch (DirectoryException directoryException) {
                // empty catch block
            }
        }
        this.dirSession = null;
    }

    private static DocumentModel getDocModel(CoreSession session, String ref, long refType, String repoId) {
        IdRef docRef;
        if (!session.getRepositoryName().equals(repoId)) {
            log.error((Object)"Multiple repository management is not handled in current implementation");
            return null;
        }
        if (refType == 1L) {
            docRef = new IdRef(ref);
        } else if (refType == 2L) {
            docRef = new PathRef(ref);
        } else {
            log.error((Object)"Unknown reference type");
            return null;
        }
        DocumentModel doc = null;
        try {
            doc = session.getDocument((DocumentRef)docRef);
        }
        catch (DocumentNotFoundException | DocumentSecurityException e) {
            log.warn((Object)("document with ref " + ref + " was not found : " + e.getMessage()));
            return null;
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DocumentModel> loadPersistentDocumentsLists(CoreSession currentSession, String userName, String listName) {
        ArrayList<DocumentModel> docList = new ArrayList<DocumentModel>();
        if (!this.initPersistentService()) {
            return docList;
        }
        try {
            DocumentModelList entries;
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put(DIR_COL_LISTID, listName);
            filter.put(DIR_COL_USERID, userName);
            try {
                entries = this.dirSession.query(filter);
            }
            catch (DirectoryException e) {
                log.error((Object)e, (Throwable)e);
                ArrayList<DocumentModel> arrayList = docList;
                this.releasePersistenceService();
                return arrayList;
            }
            for (DocumentModel entry : entries) {
                String repo;
                long reftype;
                String ref = (String)entry.getProperty(this.directorySchema, DIR_COL_REF);
                DocumentModel doc = DocumentsListsPersistenceManager.getDocModel(currentSession, ref, reftype = ((Long)entry.getProperty(this.directorySchema, DIR_COL_REFTYPE)).longValue(), repo = (String)entry.getProperty(this.directorySchema, DIR_COL_REPO));
                if (doc != null) {
                    if (docList.contains(doc)) {
                        log.warn((Object)("Document " + doc.getRef().toString() + " is duplicated in persistent list " + listName));
                        try {
                            this.dirSession.deleteEntry(entry.getId());
                        }
                        catch (DirectoryException e) {
                            log.error((Object)"Sanity fix failed", (Throwable)e);
                        }
                        continue;
                    }
                    docList.add(doc);
                    continue;
                }
                try {
                    this.dirSession.deleteEntry(entry.getId());
                }
                catch (DirectoryException e) {
                    log.error((Object)("Unable to remove non existing document model entry : " + entry.getId()), (Throwable)e);
                }
            }
            ArrayList<DocumentModel> arrayList = docList;
            return arrayList;
        }
        finally {
            this.releasePersistenceService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean addDocumentToPersistentList(String userName, String listName, DocumentModel doc) {
        if (!this.initPersistentService()) {
            return false;
        }
        try {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put(DIR_COL_LISTID, listName);
            fields.put(DIR_COL_USERID, userName);
            fields.put(DIR_COL_REF, doc.getRef().toString());
            fields.put(DIR_COL_REFTYPE, Long.valueOf(doc.getRef().type()));
            fields.put(DIR_COL_REPO, doc.getRepositoryName());
            String id = DocumentsListsPersistenceManager.getIdForEntry(userName, listName, doc);
            fields.put("id", id);
            try {
                DocumentModel badEntry = this.dirSession.getEntry(id);
                if (badEntry != null) {
                    log.warn((Object)("Entry with id " + id + " is already present : please check DB integrity"));
                    this.dirSession.deleteEntry(id);
                }
                this.dirSession.createEntry(fields);
            }
            catch (DirectoryException e) {
                log.error((Object)"Unable to create entry", (Throwable)e);
                Boolean bl = false;
                this.releasePersistenceService();
                return bl;
            }
            Boolean bl = true;
            return bl;
        }
        finally {
            this.releasePersistenceService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean removeDocumentFromPersistentList(String userName, String listName, DocumentModel doc) {
        if (!this.initPersistentService()) {
            return false;
        }
        try {
            String entryId = DocumentsListsPersistenceManager.getIdForEntry(userName, listName, doc);
            try {
                this.dirSession.deleteEntry(entryId);
            }
            catch (DirectoryException e) {
                log.error((Object)"Unable to delete entry", (Throwable)e);
                Boolean bl = false;
                this.releasePersistenceService();
                return bl;
            }
            Boolean bl = true;
            return bl;
        }
        finally {
            this.releasePersistenceService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean clearPersistentList(String userName, String listName) {
        if (!this.initPersistentService()) {
            return false;
        }
        try {
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put(DIR_COL_LISTID, listName);
            filter.put(DIR_COL_USERID, userName);
            try {
                DocumentModelList entriesToDelete = this.dirSession.query(filter);
                for (DocumentModel entry : entriesToDelete) {
                    this.dirSession.deleteEntry(entry.getId());
                }
            }
            catch (DirectoryException e) {
                log.error((Object)"Unable to clear DocumentList", (Throwable)e);
                Boolean bl = false;
                this.releasePersistenceService();
                return bl;
            }
            Boolean bl = true;
            return bl;
        }
        finally {
            this.releasePersistenceService();
        }
    }
}

