/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.we;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.connect.data.DownloadablePackage;

public class StudioSnapshotHelper {
    public static final String SNAPSHOT_SUFFIX = "0.0.0-SNAPSHOT";

    private StudioSnapshotHelper() {
    }

    public static boolean isSnapshot(DownloadablePackage pkg) {
        return pkg.getVersion() != null && pkg.getVersion().toString().endsWith(SNAPSHOT_SUFFIX);
    }

    public static List<DownloadablePackage> removeSnapshot(List<DownloadablePackage> pkgs) {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        for (DownloadablePackage pkg : pkgs) {
            if (StudioSnapshotHelper.isSnapshot(pkg)) continue;
            result.add(pkg);
        }
        return result;
    }

    public static DownloadablePackage getSnapshot(List<DownloadablePackage> pkgs) {
        for (DownloadablePackage pkg : pkgs) {
            if (!StudioSnapshotHelper.isSnapshot(pkg)) continue;
            return pkg;
        }
        return null;
    }
}

