/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.shield;

import java.io.Serializable;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.faces.Redirect;
import org.jboss.seam.transaction.Transaction;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;

@Deprecated
public class NuxeoErrorInterceptor
implements Serializable {
    private static final long serialVersionUID = 6519836435278721L;
    private static final Log log = LogFactory.getLog(NuxeoErrorInterceptor.class);
    private static final String GENERIC_ERROR_VIEW_ID = "/generic_error_page.xhtml";
    private static final String UNTHEMED_ERROR_VIEW_ID = "/unthemed_generic_error_page.xhtml";
    private static final String LOGIN_VIEW_ID = "/login.jsp";

    @AroundInvoke
    public Object invokeAndWrapExceptions(InvocationContext invocation) throws SystemException, DocumentSecurityException {
        try {
            return invocation.proceed();
        }
        catch (Exception t) {
            String pageName;
            String[] previousPage;
            Map requestMap;
            ExternalContext externalContext;
            ExceptionUtils.checkInterrupt((Exception)t);
            if (Transaction.instance().isActive()) {
                Transaction.instance().setRollbackOnly();
            }
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (FacesLifecycle.getPhaseId() == PhaseId.RENDER_RESPONSE && ExceptionHelper.isSecurityError((Throwable)t)) {
                Object req;
                if (facesContext != null && (req = facesContext.getExternalContext().getRequest()) instanceof ServletRequest) {
                    ServletRequest request = (ServletRequest)req;
                    request.setAttribute("securityException", (Object)t);
                }
                throw new DocumentSecurityException("Security Error during call of " + invocation.getTarget().toString(), (Throwable)t);
            }
            NuxeoException cException = new NuxeoException((Throwable)t);
            if (FacesLifecycle.getPhaseId() == PhaseId.RENDER_RESPONSE) {
                Object req;
                if (facesContext != null && (req = facesContext.getExternalContext().getRequest()) instanceof ServletRequest) {
                    ServletRequest request = (ServletRequest)req;
                    request.setAttribute("applicationException", (Object)cException);
                }
                throw cException;
            }
            if (facesContext != null && (externalContext = facesContext.getExternalContext()) != null && (requestMap = externalContext.getRequestHeaderValuesMap()) != null && (previousPage = (String[])requestMap.get("Referer")) != null && previousPage.length != 0 && (pageName = previousPage[0]) != null && pageName.contains("error_page")) {
                this.redirectToErrorPage(UNTHEMED_ERROR_VIEW_ID);
                return null;
            }
            String redirectToViewId = null;
            try {
                log.error((Object)"Exception caught, redirecting to the error page...", (Throwable)cException);
                Context sessionContext = Contexts.getSessionContext();
                sessionContext.set("applicationException", (Object)cException);
                redirectToViewId = ExceptionHelper.isSecurityError((Throwable)t) || cException.getCause() instanceof DocumentSecurityException ? LOGIN_VIEW_ID : GENERIC_ERROR_VIEW_ID;
            }
            catch (RuntimeException e) {
                log.error((Object)e, (Throwable)e);
                redirectToViewId = UNTHEMED_ERROR_VIEW_ID;
            }
            if (this.redirectToErrorPage(redirectToViewId)) {
                return null;
            }
            log.info((Object)"Unable to handle exception in web-context. It might be an external (soap) request. Throwing further...");
            log.error((Object)"Original error", (Throwable)t);
            throw cException;
        }
    }

    private boolean redirectToErrorPage(String viewId) {
        String logPrefix = "<redirectToErrorPage> ";
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            log.info((Object)"<redirectToErrorPage> cannot redirect to error page");
            return false;
        }
        HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)Boolean.TRUE);
        Redirect.instance().setViewId(viewId);
        Redirect.instance().execute();
        return true;
    }
}

