/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.bulkedit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.webapp.bulkedit.BulkEditService;
import org.nuxeo.runtime.api.Framework;

public class BulkEditHelper {
    private static final Log log = LogFactory.getLog(BulkEditHelper.class);
    @Deprecated
    public static final String BULK_EDIT_PREFIX = "bulkEdit/";
    @Deprecated
    public static final String CONTEXT_DATA = "contextData";

    private BulkEditHelper() {
    }

    public static List<String> getCommonLayouts(TypeManager typeManager, List<DocumentModel> docs) {
        return BulkEditHelper.getCommonLayouts(typeManager, docs, "edit");
    }

    public static List<String> getCommonLayouts(TypeManager typeManager, List<DocumentModel> docs, String mode) {
        ArrayList<String> layouts = null;
        for (DocumentModel doc : docs) {
            Type type = typeManager.getType(doc.getType());
            List<String> typeLayouts = Arrays.asList(type.getLayouts(mode));
            if (layouts == null) {
                layouts = new ArrayList<String>();
                layouts.addAll(typeLayouts);
                continue;
            }
            layouts.retainAll(typeLayouts);
        }
        return layouts;
    }

    public static List<String> getCommonSchemas(List<DocumentModel> docs) {
        ArrayList<String> schemas = null;
        for (DocumentModel doc : docs) {
            List<String> docSchemas = Arrays.asList(doc.getSchemas());
            if (schemas == null) {
                schemas = new ArrayList<String>();
                schemas.addAll(docSchemas);
                continue;
            }
            schemas.retainAll(docSchemas);
        }
        return schemas;
    }

    @Deprecated
    public static void copyMetadata(CoreSession session, DocumentModel sourceDoc, List<DocumentModel> targetDocs) {
        ((BulkEditService)Framework.getLocalService(BulkEditService.class)).updateDocuments(session, sourceDoc, targetDocs);
    }

    @Deprecated
    protected static List<String> getPropertiesToCopy(DocumentModel sourceDoc) {
        ArrayList<String> propertiesToCopy = new ArrayList<String>();
        for (Map.Entry entry : sourceDoc.getContextData().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(BULK_EDIT_PREFIX)) continue;
            String[] properties = key.replace(BULK_EDIT_PREFIX, "").split(" ");
            Serializable value = (Serializable)entry.getValue();
            if (!(value instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            for (String property : properties) {
                if (property.startsWith(CONTEXT_DATA)) continue;
                propertiesToCopy.add(property);
            }
        }
        return propertiesToCopy;
    }
}

