/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.directory.SizeLimitExceededException;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

@Name(value="principalListManager")
@Scope(value=ScopeType.SESSION)
public class PrincipalListManager
implements Serializable {
    public static final String USER_TYPE = "USER_TYPE";
    public static final String GROUP_TYPE = "GROUP_TYPE";
    public static final String USER_GROUP_TYPE = "USER_GROUP_TYPE";
    public static final String USER_ICON = "/icons/user.png";
    public static final String GROUP_ICON = "/icons/group.png";
    public static final String USER_ICON_ALT = "user.png";
    public static final String GROUP_ICON_ALT = "group.png";
    public static final int MAX_SEARCH_RESULTS = 20;
    private static final long serialVersionUID = 1859670282887307916L;
    private static final Log log = LogFactory.getLog(PrincipalListManager.class);
    public final Map<String, String> iconPath;
    public final Map<String, String> iconAlt;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient UserManager userManager;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    protected SelectItem[] availablePrincipals;
    protected Map<String, String> principalTypes = new HashMap<String, String>();
    protected String selectedPrincipal;
    protected String searchType;
    protected List<String> selectedUsers;
    @In(required=false)
    String searchFilter;
    private boolean searchOverflow;
    protected transient List<Map<String, Object>> previousSuggestedEntries;
    protected transient String previousSearchFilter;
    protected transient String previousSearchType;
    protected transient boolean previousSearchOverflow;

    public PrincipalListManager() {
        this.iconPath = new HashMap<String, String>();
        this.iconAlt = new HashMap<String, String>();
        this.iconPath.put(USER_TYPE, USER_ICON);
        this.iconPath.put(GROUP_TYPE, GROUP_ICON);
        this.iconAlt.put(USER_TYPE, USER_ICON_ALT);
        this.iconAlt.put(GROUP_TYPE, GROUP_ICON_ALT);
        this.searchType = USER_GROUP_TYPE;
    }

    public String getSearchFilter() {
        return this.searchFilter;
    }

    public void setSearchFilter(String searchFilter) {
        Context pageContext = Contexts.getPageContext();
        if (pageContext != null) {
            pageContext.set("searchFilter", (Object)searchFilter);
        }
        this.searchFilter = searchFilter;
    }

    public String getSelectedPrincipal() {
        return this.selectedPrincipal;
    }

    public String getPrincipalType(String name) {
        String type;
        if (name == null) {
            return null;
        }
        if (this.principalTypes == null) {
            this.principalTypes = new HashMap<String, String>();
        }
        if ((type = this.principalTypes.get(name)) == null) {
            type = this.userManager.getGroup(name) != null ? GROUP_TYPE : USER_TYPE;
            this.principalTypes.put(name, type);
        }
        return type;
    }

    public void setSelectedPrincipal(String selectedPrincipal) {
        this.selectedPrincipal = selectedPrincipal;
    }

    protected DocumentModelList getSuggestedUsers() {
        DocumentModelList result;
        if (this.searchFilter == null || this.searchFilter.length() == 0) {
            return new DocumentModelListImpl();
        }
        try {
            result = this.userManager.searchUsers(this.searchFilter);
        }
        catch (SizeLimitExceededException e) {
            this.searchOverflow = true;
            return new DocumentModelListImpl();
        }
        if (result.size() > 20) {
            this.searchOverflow = true;
            return new DocumentModelListImpl();
        }
        return result;
    }

    protected DocumentModelList getSuggestedGroups() {
        DocumentModelList result;
        if (this.searchFilter == null || this.searchFilter.length() == 0) {
            return new DocumentModelListImpl();
        }
        try {
            result = this.userManager.searchGroups(this.searchFilter);
        }
        catch (SizeLimitExceededException e) {
            this.searchOverflow = true;
            return new DocumentModelListImpl();
        }
        if (result.size() > 20) {
            this.searchOverflow = true;
            return new DocumentModelListImpl();
        }
        return result;
    }

    public List<Map<String, Object>> getSuggestedEntries() {
        if (this.searchFilter == null || this.searchFilter.length() == 0) {
            return Collections.emptyList();
        }
        if (this.searchFilter.equals(this.previousSearchFilter) && this.searchType.equals(this.previousSearchType)) {
            this.searchOverflow = this.previousSearchOverflow;
            return this.previousSuggestedEntries;
        }
        this.searchOverflow = false;
        Object users = USER_TYPE.equals(this.searchType) || USER_GROUP_TYPE.equals(this.searchType) || StringUtils.isEmpty((String)this.searchType) ? this.getSuggestedUsers() : new DocumentModelListImpl();
        Object groups = GROUP_TYPE.equals(this.searchType) || USER_GROUP_TYPE.equals(this.searchType) || StringUtils.isEmpty((String)this.searchType) ? this.getSuggestedGroups() : new DocumentModelListImpl();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(users.size() + groups.size());
        for (DocumentModel user : users) {
            if (user == null) continue;
            NuxeoPrincipal principal = this.userManager.getPrincipal(user.getId());
            String name = principal.getName();
            StringBuilder label = new StringBuilder(name).append("  (");
            if (principal.getFirstName() != null) {
                label.append(principal.getFirstName());
            }
            if (principal.getLastName() != null) {
                label.append(' ').append(principal.getLastName());
            }
            label.append(')');
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("label", label.toString());
            entry.put("id", name);
            entry.put("icon", "icons/user.png");
            result.add(entry);
        }
        for (DocumentModel group : groups) {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            try {
                entry.put("label", group.getProperty(this.userManager.getGroupSchemaName(), this.userManager.getGroupLabelField()));
            }
            catch (PropertyException e) {
                log.warn((Object)("Unable to get group label of " + group.getId()));
                log.debug((Object)e);
                entry.put("label", group.getId());
            }
            entry.put("id", group.getId());
            entry.put("icon", "icons/group.png");
            result.add(entry);
        }
        this.previousSuggestedEntries = result;
        this.previousSearchOverflow = this.searchOverflow;
        this.previousSearchType = this.searchType;
        this.previousSearchFilter = this.searchFilter;
        return result;
    }

    public boolean getDisplaySearchResults() {
        return this.searchFilter != null && this.searchFilter.length() != 0;
    }

    public void resetSearchFilter() {
        this.searchFilter = null;
    }

    public String addToSelectedUsers(String userName) {
        if (this.selectedUsers == null) {
            this.selectedUsers = new ArrayList<String>();
        }
        if (!this.selectedUsers.contains(userName)) {
            this.selectedUsers.add(userName);
        }
        return null;
    }

    public String removeFromSelectedUsers(String userName) {
        if (this.selectedUsers == null) {
            this.selectedUsers = new ArrayList<String>();
        }
        if (this.selectedUsers.contains(userName)) {
            this.selectedUsers.remove(userName);
        }
        return null;
    }

    public List<String> getSelectedUsers() {
        if (this.selectedUsers == null) {
            return new ArrayList<String>();
        }
        return this.selectedUsers;
    }

    public void setSelectedUsers(List<String> selectedUsers) {
        this.selectedUsers = selectedUsers;
    }

    public boolean getSelectedUserListEmpty() {
        return this.selectedUsers == null || this.selectedUsers.isEmpty();
    }

    public void resetSelectedUserList() {
        this.selectedUsers = null;
    }

    public boolean getSearchOverflow() {
        return this.searchOverflow;
    }

    public String getSearchType() {
        return this.searchType;
    }

    public void setSearchType(String searchType) {
        if (searchType == null) {
            searchType = USER_GROUP_TYPE;
        }
        this.searchType = searchType;
    }
}

