/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.function;

import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.ajax4jsf.javascript.ScriptUtils;
import org.richfaces.cdk.annotations.Function;
import org.richfaces.renderkit.util.RendererUtils;
import org.richfaces.util.Sets;

public final class RichFunction {
    private static final RendererUtils RENDERER_UTILS = RendererUtils.getInstance();
    private static ComponentLocator locator = new ComponentLocator(){

        @Override
        public UIComponent findComponent(FacesContext context, UIComponent contextComponent, String id) {
            return RENDERER_UTILS.findComponentFor(contextComponent, id);
        }
    };

    private RichFunction() {
    }

    static void setComponentLocator(ComponentLocator mockLocator) {
        locator = mockLocator;
    }

    public static UIComponent findComponent(FacesContext context, String id) {
        if (id != null) {
            UIComponent component;
            UIComponent contextComponent = UIComponent.getCurrentComponent((FacesContext)context);
            if (contextComponent == null) {
                contextComponent = context.getViewRoot();
            }
            if ((component = locator.findComponent(context, contextComponent, id)) != null) {
                return component;
            }
        }
        return null;
    }

    @Function
    public static String clientId(String id) {
        FacesContext context = FacesContext.getCurrentInstance();
        UIComponent component = RichFunction.findComponent(context, id);
        return component != null ? component.getClientId(context) : null;
    }

    @Function
    public static String component(String id) {
        String clientId = RichFunction.clientId(id);
        if (clientId != null) {
            return "RichFaces.component('" + clientId + "')";
        }
        return null;
    }

    @Function
    public static String element(String id) {
        String clientId = RichFunction.clientId(id);
        if (clientId != null) {
            return "document.getElementById('" + clientId + "')";
        }
        return null;
    }

    @Function
    public static String jQuerySelector(String id) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIComponent component = RichFunction.findComponent(facesContext, id);
        if (component != null) {
            return RichFunction.jQuerySelector(facesContext, component);
        }
        return null;
    }

    public static String jQuerySelector(FacesContext facesContext, UIComponent component) {
        if (facesContext == null) {
            throw new IllegalArgumentException("facesContext can't be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("component can't be null");
        }
        String clientId = component.getClientId(facesContext);
        return "#" + ScriptUtils.escapeCSSMetachars((String)ScriptUtils.escapeCSSMetachars((String)clientId));
    }

    @Function
    public static String jQuery(String id) {
        String element = RichFunction.element(id);
        if (element != null) {
            return "RichFaces.jQuery(" + element + ")";
        }
        return "RichFaces.jQuery()";
    }

    @Function
    public static UIComponent findComponent(String id) {
        return RichFunction.findComponent(FacesContext.getCurrentInstance(), id);
    }

    @Function
    public static boolean isUserInRole(Object rolesObject) {
        Set rolesSet = Sets.asSet((Object)rolesObject);
        if (rolesSet != null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            for (String role : rolesSet) {
                if (!externalContext.isUserInRole(role)) continue;
                return true;
            }
        }
        return false;
    }

    @Function
    public static String toScript(Object o) {
        return ScriptUtils.toScript((Object)o);
    }

    protected static interface ComponentLocator {
        public UIComponent findComponent(FacesContext var1, UIComponent var2, String var3);
    }
}

