/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.util;

import com.noelios.restlet.util.FormUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.resource.Representation;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormReader {
    private InputStream stream;
    private Logger logger;
    private CharacterSet characterSet;

    public FormReader(Logger logger, Representation representation) throws IOException {
        this.logger = logger;
        this.stream = representation.getStream();
        this.characterSet = representation.getCharacterSet() != null ? representation.getCharacterSet() : CharacterSet.UTF_8;
    }

    public FormReader(Logger logger, String query, CharacterSet characterSet) throws IOException {
        this.logger = logger;
        this.stream = new ByteArrayInputStream(query.getBytes());
        this.characterSet = characterSet;
    }

    public Object readParameter(String name) throws IOException {
        Parameter param = this.readNextParameter();
        Object result = null;
        while (param != null) {
            if (param.getName().equals(name)) {
                if (result != null) {
                    ArrayList<Object> values = null;
                    if (result instanceof List) {
                        values = (ArrayList<Object>)result;
                    } else {
                        values = new ArrayList<Object>();
                        values.add(result);
                        result = values;
                    }
                    if (param.getValue() == null) {
                        values.add(Series.EMPTY_VALUE);
                    } else {
                        values.add(param.getValue());
                    }
                } else {
                    result = param.getValue() == null ? Series.EMPTY_VALUE : param.getValue();
                }
            }
            param = this.readNextParameter();
        }
        this.stream.close();
        return result;
    }

    public Parameter readFirstParameter(String name) throws IOException {
        Parameter param = this.readNextParameter();
        Parameter result = null;
        while (param != null && result == null) {
            if (param.getName().equals(name)) {
                result = param;
            }
            param = this.readNextParameter();
        }
        this.stream.close();
        return result;
    }

    public void readParameters(Map<String, Object> parameters) throws IOException {
        Parameter param = this.readNextParameter();
        Object currentValue = null;
        while (param != null) {
            if (parameters.containsKey(param.getName())) {
                currentValue = parameters.get(param.getName());
                if (currentValue != null) {
                    ArrayList<Object> values = null;
                    if (currentValue instanceof List) {
                        values = (ArrayList<Object>)currentValue;
                    } else {
                        values = new ArrayList<Object>();
                        values.add(currentValue);
                        parameters.put(param.getName(), values);
                    }
                    if (param.getValue() == null) {
                        values.add(Series.EMPTY_VALUE);
                    } else {
                        values.add(param.getValue());
                    }
                } else if (param.getValue() == null) {
                    parameters.put(param.getName(), Series.EMPTY_VALUE);
                } else {
                    parameters.put(param.getName(), param.getValue());
                }
            }
            param = this.readNextParameter();
        }
        this.stream.close();
    }

    public Parameter readNextParameter() throws IOException {
        Parameter result = null;
        try {
            boolean readingName = true;
            boolean readingValue = false;
            StringBuilder nameBuffer = new StringBuilder();
            StringBuilder valueBuffer = new StringBuilder();
            int nextChar = 0;
            while (result == null && nextChar != -1) {
                nextChar = this.stream.read();
                if (readingName) {
                    if (nextChar == 61) {
                        if (nameBuffer.length() > 0) {
                            readingName = false;
                            readingValue = true;
                            continue;
                        }
                        throw new IOException("Empty parameter name detected. Please check your form data");
                    }
                    if (nextChar == 38 || nextChar == -1) {
                        if (nameBuffer.length() > 0) {
                            result = FormUtils.create(nameBuffer, null, this.characterSet);
                            continue;
                        }
                        if (nextChar == -1) continue;
                        throw new IOException("Empty parameter name detected. Please check your form data");
                    }
                    nameBuffer.append((char)nextChar);
                    continue;
                }
                if (!readingValue) continue;
                if (nextChar == 38 || nextChar == -1) {
                    if (valueBuffer.length() > 0) {
                        result = FormUtils.create(nameBuffer, valueBuffer, this.characterSet);
                        continue;
                    }
                    result = FormUtils.create(nameBuffer, null, this.characterSet);
                    continue;
                }
                valueBuffer.append((char)nextChar);
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new IOException("Unsupported encoding. Please contact the administrator");
        }
        return result;
    }

    public Form read() throws IOException {
        Form result = new Form();
        Parameter param = this.readNextParameter();
        while (param != null) {
            result.add((Object)param);
            param = this.readNextParameter();
        }
        this.stream.close();
        return result;
    }

    public void addParameters(Form form) {
        boolean readNext = true;
        Parameter param = null;
        while (readNext) {
            try {
                param = this.readNextParameter();
                if (param != null) {
                    form.add((Object)param);
                    continue;
                }
                readNext = false;
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.WARNING, "Unable to parse a form parameter. Skipping it.", ioe);
            }
        }
        try {
            this.stream.close();
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, "Unable to close the form input stream", ioe);
        }
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(FormReader.class.getCanonicalName());
        }
        return this.logger;
    }
}

