/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.web;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.ui.web.invalidations.AutomaticDocumentBasedInvalidation;
import org.nuxeo.ecm.platform.ui.web.invalidations.DocumentContextBoundActionBean;
import org.nuxeo.runtime.api.Framework;

@Name(value="docRoutingSuggestionActions")
@Scope(value=ScopeType.CONVERSATION)
@AutomaticDocumentBasedInvalidation
public class DocumentRoutingSuggestionActionsBean
extends DocumentContextBoundActionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CURRENT_DOC_ROUTING_SEARCH_ATTACHED_DOC = "CURRENT_DOC_ROUTING_SEARCH_ATTACHED_DOC";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;

    public DocumentModel getDocumentModel(String id) {
        return this.documentManager.getDocument((DocumentRef)new IdRef(id));
    }

    public List<DocumentModel> getDocumentSuggestions(Object input) {
        PageProviderService pageProviderService = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("maxResults", "PAGE_SIZE");
        props.put("coreSession", (Serializable)this.documentManager);
        PageProvider pageProvider = pageProviderService.getPageProvider(CURRENT_DOC_ROUTING_SEARCH_ATTACHED_DOC, null, null, Long.valueOf(0L), props, new Object[]{String.format("%s%%", input)});
        return pageProvider.getCurrentPage();
    }

    public List<DocumentModel> getRouteModelSuggestions(Object input) {
        DocumentRoutingService documentRoutingService = (DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class);
        return documentRoutingService.searchRouteModels(this.documentManager, (String)input);
    }

    protected void resetBeanCache(DocumentModel newCurrentDocumentModel) {
    }
}

