/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.rest;

import com.sun.faces.application.ApplicationAssociate;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.faces.FactoryFinder;
import javax.faces.application.NavigationCase;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jboss.seam.util.DTDEntityResolver;
import org.nuxeo.runtime.api.Framework;
import org.xml.sax.EntityResolver;

public class StaticNavigationHandler {
    private static final Log log = LogFactory.getLog(StaticNavigationHandler.class);
    private final HashMap<String, String> outcomeToViewId = new HashMap();
    private final HashMap<String, String> viewIdToOutcome = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaticNavigationHandler(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        boolean created = false;
        FacesContext faces = FacesContext.getCurrentInstance();
        if (faces == null) {
            FacesContextFactory facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            Lifecycle lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
            faces = facesContextFactory.getFacesContext((Object)context, (Object)request, (Object)response, lifecycle);
            created = true;
        }
        try {
            ApplicationAssociate associate = ApplicationAssociate.getCurrentInstance();
            for (Set cases : associate.getNavigationCaseListMappings().values()) {
                for (NavigationCase cnc : cases) {
                    String toViewId = cnc.getToViewId(faces);
                    String fromOutcome = cnc.getFromOutcome();
                    this.outcomeToViewId.put(fromOutcome, toViewId);
                    this.viewIdToOutcome.put(toViewId, fromOutcome);
                }
            }
            if (Framework.isDevModeSet()) {
                this.handleHotReloadResources(context);
            }
        }
        finally {
            if (created) {
                faces.release();
            }
        }
    }

    public String getOutcomeFromViewId(String viewId) {
        if (viewId == null) {
            return null;
        }
        if (this.viewIdToOutcome.containsKey(viewId = viewId.replace(".faces", ".xhtml"))) {
            return this.viewIdToOutcome.get(viewId);
        }
        return viewId;
    }

    public String getViewIdFromOutcome(String outcome) {
        if (outcome == null) {
            return null;
        }
        if (this.outcomeToViewId.containsKey(outcome)) {
            return this.outcomeToViewId.get(outcome).replace(".xhtml", ".faces");
        }
        String viewId = "/" + outcome + ".faces";
        log.warn((Object)("Guessing view id for outcome '" + outcome + "': use '" + viewId + "'"));
        return viewId;
    }

    protected void handleHotReloadResources(ServletContext context) {
        InputStream stream = null;
        if (context != null) {
            stream = context.getResourceAsStream("/WEB-INF/faces-config.xml");
        }
        if (stream != null) {
            this.parse(stream);
        }
    }

    protected void parse(InputStream stream) {
        Element root = StaticNavigationHandler.getDocumentRoot(stream);
        List elements = root.elements("navigation-rule");
        for (Element rule : elements) {
            List nav_cases = rule.elements("navigation-case");
            for (Element nav_case : nav_cases) {
                Element from_el = nav_case.element("from-outcome");
                Element to_el = nav_case.element("to-view-id");
                if (from_el == null || to_el == null) continue;
                String from = from_el.getTextTrim();
                String to = to_el.getTextTrim();
                this.outcomeToViewId.put(from, to);
                this.viewIdToOutcome.put(to, from);
            }
        }
    }

    protected static Element getDocumentRoot(InputStream stream) {
        try {
            SAXReader saxReader = new SAXReader();
            saxReader.setEntityResolver((EntityResolver)new DTDEntityResolver());
            saxReader.setMergeAdjacentText(true);
            return saxReader.read(stream).getRootElement();
        }
        catch (DocumentException de) {
            throw new RuntimeException(de);
        }
    }
}

