/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.userworkspace.web.ejb;

import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceManagerActions;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.webapp.action.MainTabsActions;
import org.nuxeo.ecm.webapp.dashboard.DashboardNavigationHelper;
import org.nuxeo.runtime.api.Framework;

@Name(value="userWorkspaceManagerActions")
@Scope(value=ScopeType.SESSION)
@Install(precedence=10)
@Startup
public class UserWorkspaceManagerActionsBean
implements UserWorkspaceManagerActions {
    public static final String DOCUMENT_VIEW = "view_documents";
    public static final String DOCUMENT_MANAGEMENT_ACTION = "documents";
    private static final long serialVersionUID = 1828552026739219850L;
    private static final Log log = LogFactory.getLog(UserWorkspaceManagerActions.class);
    protected static final String DOCUMENT_MANAGEMENT_TAB = "MAIN_TABS:documents";
    protected boolean showingPersonalWorkspace;
    protected boolean initialized;
    protected DocumentModel lastAccessedDocument;
    protected transient UserWorkspaceService userWorkspaceService;
    @In(required=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient Principal currentUser;
    @In(required=false, create=true)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient DashboardNavigationHelper dashboardNavigationHelper;
    @In(create=true)
    protected transient MainTabsActions mainTabsActions;
    @In(create=true)
    protected transient WebActions webActions;

    public void initialize() {
        log.debug((Object)"Initializing user workspace manager actions bean");
        this.showingPersonalWorkspace = false;
        this.initialized = true;
    }

    @Destroy
    public void destroy() {
        this.userWorkspaceService = null;
        log.debug((Object)"Removing user workspace actions bean");
    }

    private UserWorkspaceService getUserWorkspaceService() {
        if (this.userWorkspaceService != null) {
            return this.userWorkspaceService;
        }
        this.userWorkspaceService = (UserWorkspaceService)Framework.getLocalService(UserWorkspaceService.class);
        return this.userWorkspaceService;
    }

    public DocumentModel getCurrentUserPersonalWorkspace() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.documentManager == null) {
            return null;
        }
        return this.getUserWorkspaceService().getCurrentUserPersonalWorkspace(this.documentManager, this.navigationContext.getCurrentDocument());
    }

    public String navigateToCurrentUserPersonalWorkspace() {
        if (!this.initialized) {
            this.initialize();
        }
        String returnView = DOCUMENT_VIEW;
        this.webActions.setCurrentTabId("MAIN_TABS", DOCUMENT_MANAGEMENT_ACTION, new String[0]);
        DocumentModel currentUserPersonalWorkspace = this.getCurrentUserPersonalWorkspace();
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (!this.isShowingPersonalWorkspace() && currentDocument != null && currentDocument.getPath().segment(0) != null) {
            this.lastAccessedDocument = this.mainTabsActions.getDocumentFor(DOCUMENT_MANAGEMENT_ACTION, this.navigationContext.getCurrentDocument());
        }
        this.navigationContext.setCurrentDocument(currentUserPersonalWorkspace);
        this.showingPersonalWorkspace = true;
        Events.instance().raiseEvent("personnalWorkspace", new Object[0]);
        return returnView;
    }

    public String navigateToOverallWorkspace() {
        if (!this.initialized) {
            this.initialize();
        }
        String returnView = DOCUMENT_VIEW;
        this.webActions.setCurrentTabIds(DOCUMENT_MANAGEMENT_TAB);
        if (this.lastAccessedDocument != null) {
            this.navigationContext.setCurrentDocument(this.lastAccessedDocument);
        } else if (this.navigationContext.getCurrentDomain() != null) {
            this.navigationContext.setCurrentDocument(this.navigationContext.getCurrentDomain());
        } else if (this.documentManager.hasPermission(this.documentManager.getRootDocument().getRef(), "ReadChildren")) {
            this.navigationContext.setCurrentDocument(this.documentManager.getRootDocument());
        } else {
            this.navigationContext.setCurrentDocument(null);
            returnView = this.dashboardNavigationHelper.navigateToDashboard();
        }
        this.showingPersonalWorkspace = false;
        Events.instance().raiseEvent("goHome", new Object[0]);
        return returnView;
    }

    @Factory(value="isInsidePersonalWorkspace", scope=ScopeType.EVENT)
    public boolean isShowingPersonalWorkspace() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.mainTabsActions.isOnMainTab(DOCUMENT_MANAGEMENT_ACTION)) {
            DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
            this.showingPersonalWorkspace = this.getUserWorkspaceService().isUnderUserWorkspace(this.currentUser, null, currentDoc);
        }
        return this.showingPersonalWorkspace;
    }

    public void setShowingPersonalWorkspace(boolean showingPersonalWorkspace) {
        this.showingPersonalWorkspace = showingPersonalWorkspace;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

