/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.restAPI.service.RestletPluginDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.restlet.Restlet;

public class PluggableRestletService
extends DefaultComponent {
    public static final String NAME = "org.nuxeo.ecm.platform.ui.web.restAPI.service.PluggableRestletService";
    private static final Log log = LogFactory.getLog(PluggableRestletService.class);
    private Map<String, RestletPluginDescriptor> restletsDescriptors;

    public void activate(ComponentContext context) {
        this.restletsDescriptors = new HashMap<String, RestletPluginDescriptor>();
    }

    public void deactivate(ComponentContext context) {
        this.restletsDescriptors = null;
    }

    private void mergeDescriptors(RestletPluginDescriptor newContrib) {
        RestletPluginDescriptor oldDescriptor = this.restletsDescriptors.get(newContrib.getName());
        if (newContrib.getEnabled() != null) {
            oldDescriptor.setEnabled(newContrib.getEnabled());
        }
        if (newContrib.getUrlPatterns() != null && !newContrib.getUrlPatterns().isEmpty()) {
            oldDescriptor.getUrlPatterns().addAll(newContrib.getUrlPatterns());
        }
        if (newContrib.getClassName() != null) {
            oldDescriptor.setClassName(newContrib.getClassName());
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        RestletPluginDescriptor descriptor = (RestletPluginDescriptor)contribution;
        if (this.restletsDescriptors.containsKey(descriptor.getName())) {
            this.mergeDescriptors(descriptor);
            log.debug((Object)("merged RestletDescriptor: " + descriptor.getName()));
        } else {
            this.restletsDescriptors.put(descriptor.getName(), descriptor);
            log.debug((Object)("registered RestletDescriptor: " + descriptor.getName()));
        }
    }

    public List<String> getContributedRestletNames() {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(this.restletsDescriptors.keySet());
        return res;
    }

    public RestletPluginDescriptor getContributedRestletDescriptor(String name) {
        if (this.restletsDescriptors.containsKey(name)) {
            return this.restletsDescriptors.get(name);
        }
        return null;
    }

    public Restlet getContributedRestletByName(String name) {
        if (this.restletsDescriptors.containsKey(name)) {
            Restlet restlet;
            RestletPluginDescriptor rpd = this.restletsDescriptors.get(name);
            if (rpd == null) {
                log.error((Object)("Error while creating Restlet instance. Cannot get RestletPluginDescriptor for name: " + name));
                return null;
            }
            Class<Restlet> theClass = rpd.getClassName();
            if (theClass == null) {
                log.error((Object)("Error while creating Restlet instance. Class not available for restlet descriptor: " + name));
                return null;
            }
            try {
                restlet = theClass.newInstance();
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)("Error while creating Restlet instance for name " + name), (Throwable)e);
                return null;
            }
            return restlet;
        }
        log.error((Object)("Restlet " + name + " is not registred"));
        return null;
    }
}

