/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl;

import java.io.IOException;
import org.ajax4jsf.javascript.ScriptStringBase;
import org.richfaces.application.push.MessageData;

public class MessageDataScriptString
extends ScriptStringBase {
    private final Iterable<MessageData> messages;
    private long lastMessageNumber;

    public MessageDataScriptString(Iterable<MessageData> messages) {
        this.messages = messages;
    }

    private void appendMessageToScript(MessageData message, Appendable target) throws IOException {
        target.append("<msg topic=\"");
        target.append(message.getTopicKey().getTopicAddress());
        target.append("\" number=\"");
        target.append(Long.toString(message.getSequenceNumber()));
        target.append("\">");
        target.append(message.getSerializedMessage());
        target.append("</msg>");
    }

    @Override
    public void appendScript(Appendable target) throws IOException {
        for (MessageData message : this.messages) {
            this.appendMessageToScript(message, target);
            this.lastMessageNumber = message.getSequenceNumber();
        }
    }

    public long getLastSequenceNumber() {
        return this.lastMessageNumber;
    }
}

