/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.automation;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="RenditionDefinition.Suggestion", category="Services", label="Get rendition definition suggestion", description="Get rendition definition suggestion")
public class SuggestRenditionDefinitionEntry {
    public static final String ID = "RenditionDefinition.Suggestion";
    public static final int MAX_SUGGESTIONS = 10;
    public static final Comparator<RenditionDefinition> LABEL_COMPARATOR = new RenditionDefinitionComparator();
    @Param(name="searchTerm", required=false)
    protected String searchTerm;

    @OperationMethod
    public Blob run() {
        JSONArray result = new JSONArray();
        if (!StringUtils.isBlank((String)this.searchTerm)) {
            for (RenditionDefinition def : this.getSuggestions(this.searchTerm)) {
                JSONObject obj = new JSONObject();
                String name = def.getName();
                obj.element("id", (Object)name);
                obj.element("displayLabel", (Object)name);
                result.add((Object)obj);
            }
        }
        return Blobs.createBlob((String)result.toString(), (String)"application/json");
    }

    protected List<RenditionDefinition> getSuggestions(String searchTerm) {
        RenditionService renditionService = (RenditionService)Framework.getService(RenditionService.class);
        List defs = renditionService.getDeclaredRenditionDefinitions();
        return defs.stream().filter(def -> def.getName().startsWith(searchTerm)).sorted(LABEL_COMPARATOR).limit(10L).collect(Collectors.toList());
    }

    protected static class RenditionDefinitionComparator
    implements Comparator<RenditionDefinition> {
        protected RenditionDefinitionComparator() {
        }

        @Override
        public int compare(RenditionDefinition o1, RenditionDefinition o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }
}

