/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.io;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.ValidationEventHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import yarfraw.core.datamodel.ChannelFeed;
import yarfraw.core.datamodel.YarfrawException;
import yarfraw.io.FeedReader;

public class CachedFeedReader
extends FeedReader {
    private static final String ETAG = "ETag";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final int NOT_MODIFIED_STATUS_CODE = 304;
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private ChannelFeed _cachedChannelFeed;
    private String _lastModified;
    private String _eTag;

    public ChannelFeed readChannel() throws YarfrawException {
        try {
            this._cachedChannelFeed = super.readChannel(null);
        }
        catch (NotModfiedException notModfiedException) {
            // empty catch block
        }
        return this._cachedChannelFeed;
    }

    public ChannelFeed readChannel(ValidationEventHandler validationEventHandler) throws YarfrawException {
        try {
            this._cachedChannelFeed = super.readChannel(validationEventHandler);
        }
        catch (NotModfiedException notModfiedException) {
            // empty catch block
        }
        return this._cachedChannelFeed;
    }

    protected InputStream getStream() throws IOException {
        GetMethod get = new GetMethod(this._httpUrl.toString());
        HttpClient client = new HttpClient();
        if (this._httpClientParams != null) {
            client.setParams(this._httpClientParams);
        }
        if (this._cachedChannelFeed != null) {
            get.addRequestHeader(new Header(IF_MODIFIED_SINCE, this._lastModified));
            get.addRequestHeader(new Header(IF_NONE_MATCH, this._eTag));
        }
        client.executeMethod((HttpMethod)get);
        Header lastModified = get.getResponseHeader(LAST_MODIFIED);
        this._lastModified = lastModified == null ? null : lastModified.getValue();
        Header eTag = get.getResponseHeader(ETAG);
        String string = this._eTag = eTag == null ? null : eTag.getValue();
        if (get.getStatusCode() == 304) {
            throw new NotModfiedException();
        }
        InputStream stream = get.getResponseBodyAsStream();
        return stream;
    }

    public String getLastModified() {
        return this._lastModified;
    }

    public String getETag() {
        return this._eTag;
    }

    public void setETag(String tag) {
        this._eTag = tag;
    }

    public void setLastModified(String lastModified) {
        this._lastModified = lastModified;
    }

    public ChannelFeed getCachedChannelFeed() {
        return this._cachedChannelFeed;
    }

    public CachedFeedReader(HttpURL httpUrl, HttpClientParams params) throws YarfrawException, IOException {
        super(httpUrl, params);
    }

    public CachedFeedReader(HttpURL httpUrl) throws YarfrawException, IOException {
        super(httpUrl, null);
    }

    class NotModfiedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        NotModfiedException() {
        }
    }
}

