/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component.behavior;

import java.io.Serializable;
import javax.el.ExpressionFactory;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.JsfBehavior;
import org.richfaces.cdk.annotations.JsfBehaviorRenderer;
import org.richfaces.cdk.annotations.Tag;
import org.richfaces.cdk.annotations.TagType;
import org.richfaces.component.AbstractTogglePanel;
import org.richfaces.component.ComponentIterators;
import org.richfaces.component.behavior.ClientBehavior;
import org.richfaces.renderkit.util.RendererUtils;
import org.richfaces.view.facelets.html.CustomBehaviorHandler;

@JsfBehavior(id="org.richfaces.component.behavior.ToggleControl", tag={@Tag(name="toggleControl", handlerClass=CustomBehaviorHandler.class, type=TagType.Facelets)}, renderer=@JsfBehaviorRenderer(type="org.richfaces.component.behavior.ToggleControl"))
public class ToggleControl
extends ClientBehavior {
    public static final String BEHAVIOR_ID = "org.richfaces.component.behavior.ToggleControl";
    private static final RendererUtils RENDERER_UTILS = RendererUtils.getInstance();

    @Attribute
    public String getEvent() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.event));
    }

    public void setEvent(String eventName) {
        this.getStateHelper().eval((Serializable)((Object)PropertyKeys.event), (Object)eventName);
    }

    @Attribute
    public String getTargetItem() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.targetItem), (Object)"@next");
    }

    public void setTargetItem(String target) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.targetItem), (Object)target);
    }

    @Attribute
    public String getTargetPanel() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.targetPanel));
    }

    public void setTargetPanel(String selector) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.targetPanel), (Object)selector);
    }

    @Attribute
    public void setDisableDefault(Boolean disableDefault) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.disableDefault), (Object)disableDefault);
    }

    public Boolean getDisableDefault() {
        return Boolean.valueOf(String.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.disableDefault), (Object)true)));
    }

    public String getPanelId(ClientBehaviorContext behaviorContext) throws FacesException {
        return this.getPanel(behaviorContext.getComponent()).getClientId(behaviorContext.getFacesContext());
    }

    public AbstractTogglePanel getPanel(UIComponent comp) throws FacesException {
        String target = this.getTargetPanel();
        if (target != null) {
            UIComponent targetComponent = RENDERER_UTILS.findComponentFor(comp, target);
            if (null != targetComponent) {
                return (AbstractTogglePanel)targetComponent;
            }
            throw new FacesException("Parent panel for control (id=" + comp.getClientId(this.getFacesContext()) + ") has not been found.");
        }
        return ToggleControl.getEnclosedPanel(comp);
    }

    public static AbstractTogglePanel getEnclosedPanel(UIComponent comp) {
        if (comp == null) {
            return null;
        }
        AbstractTogglePanel panel = (AbstractTogglePanel)ComponentIterators.getParent((UIComponent)comp, AbstractTogglePanel.class);
        if (panel == null) {
            throw new FacesException("Parent panel for control (id=" + comp.getClientId(FacesContext.getCurrentInstance()) + ") has not been found.");
        }
        return panel;
    }

    public String getRendererType() {
        return BEHAVIOR_ID;
    }

    public void setLiteralAttribute(String name, Object value) {
        if (this.compare((Serializable)((Object)PropertyKeys.targetItem), name)) {
            this.setTargetItem((String)value);
        } else if (this.compare((Serializable)((Object)PropertyKeys.targetPanel), name)) {
            this.setTargetPanel((String)value);
        } else if (this.compare((Serializable)((Object)PropertyKeys.disableDefault), name)) {
            ExpressionFactory expFactory = this.getFacesContext().getApplication().getExpressionFactory();
            this.setDisableDefault((Boolean)expFactory.coerceToType(value, Boolean.class));
        }
    }

    private static enum PropertyKeys {
        event,
        targetItem,
        targetPanel,
        disableDefault;

    }
}

