/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.list;

import com.sun.faces.facelets.tag.jsf.ComponentSupport;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.component.list.UIEditableList;
import org.nuxeo.ecm.platform.ui.web.model.EditableModel;
import org.nuxeo.ecm.platform.ui.web.tag.fn.Functions;

public class UIJavascriptList
extends UIEditableList {
    public static final String COMPONENT_TYPE = UIJavascriptList.class.getName();
    public static final String COMPONENT_FAMILY = UIJavascriptList.class.getName();
    private static final Log log = LogFactory.getLog(UIJavascriptList.class);
    protected static final String TEMPLATE_INDEX_MARKER = "TEMPLATE_INDEX_MARKER";
    protected static final String ROW_INDEXES_PARAM = "rowIndex[]";
    protected static final String IS_LIST_TEMPLATE_VAR = "isListTemplate";

    public void setRowIndexes(int[] rowIndexes) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowIndexes), (Object)rowIndexes);
    }

    public int[] getRowIndexes() {
        return (int[])this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowIndexes));
    }

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    @Override
    public String getContainerClientId(FacesContext context) {
        String id = super.getClientId(context);
        int index = this.getRowIndex();
        if (index == -2) {
            id = id + ":TEMPLATE_INDEX_MARKER";
        } else if (index != -1) {
            id = id + ':' + String.valueOf(index);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encodeTemplate(FacesContext context) throws IOException {
        int oldIndex = this.getRowIndex();
        Object requestMapValue = this.saveRequestMapModelValue();
        Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
        boolean hasVar = false;
        if (requestMap.containsKey(IS_LIST_TEMPLATE_VAR)) {
            hasVar = true;
        }
        Object oldIsTemplateBoolean = requestMap.remove(IS_LIST_TEMPLATE_VAR);
        try {
            this.setRowIndex(-2);
            requestMap.put(IS_LIST_TEMPLATE_VAR, Boolean.TRUE);
            ResponseWriter oldResponseWriter = context.getResponseWriter();
            StringWriter cacheingWriter = new StringWriter();
            ResponseWriter newResponseWriter = context.getResponseWriter().cloneWithWriter((Writer)cacheingWriter);
            context.setResponseWriter(newResponseWriter);
            if (this.getChildCount() > 0) {
                for (UIComponent kid : this.getChildren()) {
                    if (!kid.isRendered()) continue;
                    try {
                        ComponentSupport.encodeRecursive((FacesContext)context, (UIComponent)kid);
                    }
                    catch (IOException err) {
                        log.error((Object)("Error while rendering component " + kid));
                    }
                }
            }
            cacheingWriter.flush();
            cacheingWriter.close();
            context.setResponseWriter(oldResponseWriter);
            String html = Functions.htmlEscape(cacheingWriter.toString());
            ResponseWriter writer = context.getResponseWriter();
            writer.write("<script type=\"text/x-html-template\">");
            writer.write(html);
            writer.write("</script>");
        }
        finally {
            this.setRowIndex(oldIndex);
            if (hasVar) {
                requestMap.put(IS_LIST_TEMPLATE_VAR, oldIsTemplateBoolean);
            } else {
                requestMap.remove(IS_LIST_TEMPLATE_VAR);
            }
            this.restoreRequestMapModelValue(requestMapValue);
        }
    }

    public void decode(FacesContext context) {
        super.decode(context);
        Map requestMap = context.getExternalContext().getRequestParameterValuesMap();
        String clientId = this.getClientId() + ':' + ROW_INDEXES_PARAM;
        Object[] v = (String[])requestMap.get(clientId);
        if (v == null) {
            this.setRowIndexes(null);
            return;
        }
        try {
            int[] indexes = new int[v.length];
            for (int i = 0; i < indexes.length; ++i) {
                indexes[i] = Integer.valueOf((String)v[i]);
            }
            this.setRowIndexes(indexes);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Invalid value '%s' for row indexes at '%s'", StringUtils.join((Object[])v, (String)","), clientId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processFacetsAndChildren(FacesContext context, PhaseId phaseId) {
        List stamps = this.getChildren();
        EditableModel model = this.getEditableModel();
        int oldIndex = this.getRowIndex();
        int[] rowIndexes = this.getRowIndexes();
        Object requestMapValue = this.saveRequestMapModelValue();
        try {
            if (phaseId == PhaseId.APPLY_REQUEST_VALUES && rowIndexes != null) {
                for (int i = 0; i < rowIndexes.length; ++i) {
                    int idx = rowIndexes[i];
                    this.setRowIndex(idx);
                    if (this.isRowAvailable()) continue;
                    model.insertValue(idx, this.getEditableModel().getUnreferencedTemplate());
                }
            }
            ArrayList<Integer> deletedIndexes = new ArrayList<Integer>();
            if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                int i;
                HashMap<Integer, Integer> keyIndexMap = new HashMap<Integer, Integer>();
                if (rowIndexes != null) {
                    for (i = 0; i < rowIndexes.length; ++i) {
                        int idx = rowIndexes[i];
                        keyIndexMap.put(idx, i);
                    }
                }
                for (i = 0; i < this.getRowCount(); ++i) {
                    if (keyIndexMap.containsKey(i)) continue;
                    deletedIndexes.add(i);
                }
            }
            int end = this.getRowCount();
            for (int idx = 0; idx < end; ++idx) {
                if (deletedIndexes.contains(idx)) continue;
                this.setRowIndex(idx);
                if (!this.isRowAvailable()) break;
                for (UIComponent stamp : stamps) {
                    this.processComponent(context, stamp, phaseId);
                }
                if (phaseId != PhaseId.UPDATE_MODEL_VALUES || !this.isRowModified()) continue;
                this.recordValueModified(idx, this.getRowData());
            }
            if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                HashMap<Integer, Integer> keyIndexMap = new HashMap<Integer, Integer>();
                if (rowIndexes != null) {
                    for (int i = 0; i < rowIndexes.length; ++i) {
                        int idx = rowIndexes[i];
                        keyIndexMap.put(idx, i);
                    }
                }
                ArrayList<Integer> toDelete = new ArrayList<Integer>();
                String cid = super.getClientId(context);
                for (int i = 0; i < this.getRowCount(); ++i) {
                    this.setRowKey(i);
                    int curIdx = this.getRowIndex();
                    if (!keyIndexMap.containsKey(i)) {
                        toDelete.add(i);
                        continue;
                    }
                    int newIdx = (Integer)keyIndexMap.get(i);
                    if (curIdx == newIdx) continue;
                    model.moveValue(curIdx, newIdx);
                    String prefix = cid + ':' + curIdx + ':';
                    String replacement = cid + ':' + newIdx + ':';
                    Iterator it = context.getClientIdsWithMessages();
                    while (it.hasNext()) {
                        String id = (String)it.next();
                        if (id == null || !id.startsWith(prefix)) continue;
                        Iterator mit = context.getMessages(id);
                        while (mit.hasNext()) {
                            context.addMessage(id.replaceFirst(prefix, replacement), (FacesMessage)mit.next());
                        }
                    }
                }
                Iterator iterator = toDelete.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    this.setRowKey(i);
                    model.removeValue(this.getRowIndex());
                }
            }
        }
        finally {
            this.setRowIndex(oldIndex);
            this.restoreRequestMapModelValue(requestMapValue);
        }
    }

    protected static enum PropertyKeys {
        rowIndexes;

    }
}

