/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptString;
import org.richfaces.application.FacesMessages;
import org.richfaces.application.MessageFactory;
import org.richfaces.application.ServiceTracker;
import org.richfaces.component.AbstractSelect;
import org.richfaces.component.AbstractSelectComponent;
import org.richfaces.component.AutocompleteMode;
import org.richfaces.component.attribute.AutocompleteProps;
import org.richfaces.component.util.InputUtils;
import org.richfaces.context.ExtendedPartialViewContext;
import org.richfaces.javascript.JavaScriptService;
import org.richfaces.renderkit.ClientSelectItem;
import org.richfaces.renderkit.InputRendererBase;
import org.richfaces.renderkit.MetaComponentRenderer;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.SelectHelper;
import org.richfaces.renderkit.util.HtmlDimensions;
import org.richfaces.validator.csv.AddCSVMessageScript;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="jquery.js"), @ResourceDependency(library="org.richfaces", name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib"), @ResourceDependency(library="org.richfaces", name="richfaces-base-component.js"), @ResourceDependency(library="org.richfaces", name="jquery.position.js"), @ResourceDependency(library="org.richfaces", name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="richfaces-utils.js"), @ResourceDependency(library="org.richfaces", name="richfaces-selection.js"), @ResourceDependency(library="org.richfaces", name="inputBase.js"), @ResourceDependency(library="org.richfaces", name="popup.js"), @ResourceDependency(library="org.richfaces", name="list.js"), @ResourceDependency(library="org.richfaces", name="popupList.js"), @ResourceDependency(library="org.richfaces", name="select.js"), @ResourceDependency(library="org.richfaces", name="select.ecss")})
public class SelectRendererBase
extends InputRendererBase
implements MetaComponentRenderer {
    public static final String ITEM_CSS = "rf-sel-opt";

    public JSReference getClientFilterFunction(UIComponent component) {
        AbstractSelect select = (AbstractSelect)component;
        String clientFilter = (String)select.getAttributes().get("clientFilterFunction");
        if (clientFilter != null && clientFilter.length() != 0) {
            return new JSReference(clientFilter);
        }
        return null;
    }

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        AbstractSelect select = (AbstractSelect)component;
        if (InputUtils.isDisabled((UIComponent)select)) {
            return;
        }
        super.doDecode(context, component);
        Map requestParameters = context.getExternalContext().getRequestParameterMap();
        if (requestParameters.get(component.getClientId(context) + ".ajax") != null) {
            PartialViewContext pvc = context.getPartialViewContext();
            pvc.getRenderIds().add(component.getClientId(context) + '@' + "items");
            context.renderResponse();
        }
    }

    public void encodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) throws IOException {
        if ("items".equals(metaComponentId)) {
            List<ClientSelectItem> clientSelectItems = this.getConvertedSelectItems(context, component);
            PartialResponseWriter partialWriter = context.getPartialViewContext().getPartialResponseWriter();
            String itemsClientId = component.getClientId() + "Items";
            partialWriter.startUpdate(itemsClientId);
            ResponseWriter responseWriter = context.getResponseWriter();
            responseWriter.startElement("div", component);
            responseWriter.writeAttribute("id", (Object)(component.getClientId() + "Items"), null);
            this.encodeItems(context, component, clientSelectItems);
            responseWriter.endElement("div");
            partialWriter.endUpdate();
            if (!clientSelectItems.isEmpty()) {
                Map dataMap = ExtendedPartialViewContext.getInstance((FacesContext)context).getResponseComponentDataMap();
                dataMap.put(component.getClientId(context), clientSelectItems);
            }
        } else {
            throw new IllegalArgumentException(metaComponentId);
        }
    }

    public void decodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) {
        throw new UnsupportedOperationException();
    }

    public void renderListHandlers(FacesContext facesContext, UIComponent component) throws IOException {
        RenderKitUtils.renderPassThroughAttributesOptimized((FacesContext)facesContext, (UIComponent)component, SelectHelper.SELECT_LIST_HANDLER_ATTRIBUTES);
    }

    public List<ClientSelectItem> getConvertedSelectItems(FacesContext facesContext, UIComponent component) {
        return SelectHelper.getConvertedSelectItems(facesContext, component);
    }

    public String getSelectInputLabel(FacesContext facesContext, UIComponent component) {
        return SelectHelper.getSelectInputLabel(facesContext, component);
    }

    protected String getMinListHeight(AbstractSelect select) {
        String height = HtmlDimensions.formatSize((String)select.getMinListHeight());
        if (height == null || height.length() == 0) {
            height = "20px";
        }
        return height;
    }

    protected String getMaxListHeight(AbstractSelect select) {
        String height = HtmlDimensions.formatSize((String)select.getMaxListHeight());
        if (height == null || height.length() == 0) {
            height = "100px";
        }
        return height;
    }

    protected String getListHeight(AbstractSelect select) {
        String height = HtmlDimensions.formatSize((String)select.getListHeight());
        if (height == null || height.length() == 0) {
            height = "auto";
        }
        return height;
    }

    protected String getListWidth(AbstractSelect select) {
        String width = HtmlDimensions.formatSize((String)select.getListWidth());
        if (width == null || width.length() == 0) {
            width = "200px";
        }
        return width;
    }

    public String encodeHeightAndWidth(UIComponent component) {
        AbstractSelect select = (AbstractSelect)component;
        String height = this.getListHeight(select);
        if (!"auto".equals(height)) {
            height = height != null && height.trim().length() != 0 ? "height: " + height : "";
        } else {
            String minHeight = this.getMinListHeight(select);
            minHeight = minHeight != null && minHeight.trim().length() != 0 ? "min-height: " + minHeight : "";
            String maxHeight = this.getMaxListHeight(select);
            maxHeight = maxHeight != null && maxHeight.trim().length() != 0 ? "max-height: " + maxHeight : "";
            height = this.concatStyles(new Object[]{minHeight, maxHeight});
        }
        String width = this.getListWidth(select);
        width = width != null && width.trim().length() != 0 ? "width: " + width : "";
        return this.concatStyles(new Object[]{height, width});
    }

    public String getListCss(UIComponent component) {
        AbstractSelect inplaceSelect = (AbstractSelect)component;
        String css = inplaceSelect.getListClass();
        css = css != null ? this.concatClasses(new Object[]{"rf-sel-lst-cord", css}) : "rf-sel-lst-cord";
        return css;
    }

    public String getSelectLabel(FacesContext facesContext, UIComponent component) {
        AbstractSelectComponent select = (AbstractSelectComponent)component;
        String label = this.getSelectInputLabel(facesContext, (UIComponent)select);
        if (label == null || "".equals(label.trim())) {
            label = select.getDefaultLabel();
        }
        return label;
    }

    public boolean isAutocomplete(UIComponent component) {
        if (!(component instanceof AbstractSelect)) {
            return false;
        }
        AbstractSelect select = (AbstractSelect)component;
        return select.getAutocompleteMethod() != null || select.getAutocompleteList() != null;
    }

    public void encodeItemsContainer(FacesContext facesContext, UIComponent component, List<ClientSelectItem> clientSelectItems) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("div", component);
        responseWriter.writeAttribute("id", (Object)(component.getClientId() + "Items"), null);
        AutocompleteMode mode = (AutocompleteMode)((Object)component.getAttributes().get("mode"));
        if (!this.isAutocomplete(component) || mode != null && mode == AutocompleteMode.client) {
            ArrayList fetchValues = new ArrayList();
            this.encodeItems(facesContext, component, clientSelectItems);
        }
        responseWriter.endElement("div");
    }

    public void encodeItems(FacesContext facesContext, UIComponent component, List<ClientSelectItem> clientSelectItems) throws IOException {
        SelectHelper.encodeItems(facesContext, component, clientSelectItems, "div", ITEM_CSS);
    }

    protected void preEncodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ScriptString script = this.prepareCSVMessageScript(facesContext);
        JavaScriptService jsService = (JavaScriptService)ServiceTracker.getService(JavaScriptService.class);
        jsService.addScript(facesContext, (Object)script);
    }

    private ScriptString prepareCSVMessageScript(FacesContext facesContext) {
        MessageFactory messageFactory = (MessageFactory)ServiceTracker.getService(MessageFactory.class);
        FacesMessage message = messageFactory.createMessage(facesContext, FacesMessage.SEVERITY_ERROR, (Enum)FacesMessages.UISELECTONE_INVALID, new Object[]{"{0}"});
        return new AddCSVMessageScript(FacesMessages.UISELECTONE_INVALID.name(), message);
    }

    protected int getMinCharsOrDefault(UIComponent component) {
        int value = 1;
        if (component instanceof AutocompleteProps && (value = ((AutocompleteProps)component).getMinChars()) < 1) {
            value = 1;
        }
        return value;
    }

    private Object saveVar(FacesContext context, String var) {
        if (var != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            return requestMap.get(var);
        }
        return null;
    }

    private void setVar(FacesContext context, String var, Object varObject) {
        if (var != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            requestMap.put(var, varObject);
        }
    }
}

